# WatSan Platform - Rapid development of national water and sanitation internet portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cornel Nitu, Eau De Web
# Andrei Laza, Eau de Web

#Zope imports
import zLOG

#Product imports
import UserRegistration

def initialize(context):
    """
        Product initialization method
        @param context: Zope server context
    """
    try:
        context.registerClass(
            UserRegistration.UserRegistration,
            constructors = (
                UserRegistration.manage_addUserRegistration,
                ),
            icon = 'media/UserRegistration.gif'
        )
    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        zLOG.LOG(__name__, zLOG.INFO, 'An error occurred during product initialization. The User Registration object will not be available', error = (type, val, tb), reraise=True)
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb

