# WatSan Platform - Rapid development of national water and sanitation internet portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web

#Python imports
from unittest import TestSuite, makeSuite
from BeautifulSoup import BeautifulSoup

#Product imports
from ws.common.tests import WatsanTestCase



class SiteIndexTests(WatsanTestCase):

    def afterSetup(self):
        pass

    def beforeTearDown(self):
        pass

    def testNothing(self):
        pass

    def testMenunav(self):
        self.browser.open(self.website.absolute_url())

        soup = BeautifulSoup(self.browser.contents)
        menunav = soup.find('div', attrs={'id': 'menunav'})
        self.assertTrue(menunav is not None)

        rel_paths = ['', '/at_a_glance', '/what_can_i_do', '/country_portals', '/new_portal']
        for rp in rel_paths:
            url = self.website.absolute_url() + rp
            link = menunav.find('a', attrs={'href': url})
            self.assertTrue(link is not None)



def test_suite():
    suite = TestSuite()
    suite.addTest(makeSuite(SiteIndexTests))
    return suite

