'''
Created on May 19, 2010

@author: cristiroma
'''
import formencode
from ws.common import validation

class AddNewPortalFormStep1(formencode.Schema):
    filter_extra_fields = True
    allow_extra_fields = True

    level = formencode.validators.OneOf(['1', '2', '3', '4', '5'], not_empty=True, testValueList=True)
    country = formencode.validators.String(not_empty=True)
    language = formencode.validators.OneOf(['en', 'fr', 'pt'], not_empty=True)
    languages = formencode.validators.OneOf(['en', 'fr', 'pt'], testValueList=True, not_empty=True)
    skin = formencode.validators.OneOf(['scheme', 'uganda'], not_empty=True)
    moderation = formencode.validators.OneOf([1, 0], not_empty=True)


class AddNewPortalFormStep2(AddNewPortalFormStep1):

    mapserver_url = formencode.validators.String(not_empty=True)
    map_centerx = formencode.validators.Number(not_empty=True)
    map_centery = formencode.validators.Number(not_empty=True)
    zoom = formencode.validators.Number(not_empty=True)



def validate_new_dictionary_entry(value_dict, state, validator):
    ret = {}
    session = state
    key = value_dict.get('code', '')
    value = value_dict.get('name', '')
    klass = value_dict.get('klass', None)

    if not value or not value.strip():
        ret['code'] = 'Enter name of the property'
    if not key or not key.strip():
        ret['code'] = 'Enter a valid code'
    else:
        count = session.query(klass).filter_by(code=key).count()
        if count:
            ret['code'] = 'This key (%s) already exists, choose another code' % key
    return ret




