# WatSan Platform - Rapid development of national water and sanitation internet portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
# Andrei Laza, Eau de Web

import sys, traceback, string

#Zope imports
import zLOG
from App.ImageFile import ImageFile

#Product imports
import WSToolkit

__doc__ = """ This Zope product represents the WatSan toolkit. See specifications for more details on this component"""
__version__ = '0.0.1'

def initialize(context):
    """
        Product initialization method
        @param context: Zope server context
    """
    try:
        context.registerClass(
            WSToolkit.WSToolkit,
            constructors = (
                WSToolkit.manage_addWSToolkit_html,
                WSToolkit.manage_addWSToolkit,
                ),
        )
    except Exception, ex:
        type, val, tb = sys.exc_info()
        zLOG.LOG(__name__, zLOG.INFO, 'An error occurred during product initialization. The WatSan toolkit will not be available', error = (type, val, tb), reraise=True)
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb
        raise ex


misc_ = {
        'login.gif': ImageFile('www/login.gif', globals()),
        'full_logo.gif': ImageFile('www/full_logo.gif', globals()),
        'menu.jpg': ImageFile('www/menu.jpg', globals()),
        'subimages.gif': ImageFile('www/subimages.gif', globals()),
        'subs_background.png': ImageFile('www/subs_background.png', globals()),
        'do_sub.gif': ImageFile('www/do_sub.gif', globals()),
        'create_sub.gif': ImageFile('www/create_sub.gif', globals()),
        'country_sub.gif': ImageFile('www/country_sub.gif', globals()),
        'supported_by.gif': ImageFile('www/supported_by.gif', globals()),
        'footer.gif': ImageFile('www/footer.gif', globals()),
        'watsan_logo_small.jpg': ImageFile('www/watsan-logo-small.jpg', globals()),
}
