'''
Created on Feb 19, 2010

@author: cristiroma
'''
from Products.Naaya.NyFolder import addNyFolder

from DateTime import DateTime
from AccessControl import ClassSecurityInfo

from Products.naayaUpdater.update_scripts import UpdateScript
from Products.WSPortal.Access.WSPortalAccess import create_wsportalaccess_object_callback


class Update_0_0_7(UpdateScript):

    OLD_VERSION = '0.0.6'
    NEW_VERSION = '0.0.7'

    id = 'update_wsportal_%s' % (NEW_VERSION.replace('.', '_'))
    title = 'Update WSPortal from version %s to version %s' % (OLD_VERSION, NEW_VERSION)
    creation_date = DateTime('Mar 9, 2010')
    authors = ['Cristian Romanescu', 'Andrei Laza']
    description = 'WSPortal/WSAccess is re-created'

    security = ClassSecurityInfo()

    security.declarePrivate('_update')
    def _update(self, portal):
        if not hasattr(portal, '_last_update_version'):
            self.log.warn('Portal does not have last update version information')
        elif portal._last_update_version != self.OLD_VERSION:
            self.log.warn('Portal last update version is ' + portal._last_update_version)

        try:
            portal.manage_delObjects(['access'])
        except:
            self.log.warn('access/ section does not exist. Nothing to delete')
        addNyFolder(portal, 'access', None, self.REQUEST.AUTHENTICATED_USER.getUserName(), create_wsportalaccess_object_callback, title='Access')

        portal._last_update_version = self.NEW_VERSION
        return True


