# WatSan Platform - Rapid development of national water and sanitation internet portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web

#Python imports
from unittest import TestSuite, makeSuite

#Product imports
from ws.common.tests import WatsanTestCase
from Products.WSPortal.WSPortal import manage_addWSPortal
from ws.common.exceptions import ValidationException



class WSPortalTest(WatsanTestCase):

    def test_manageAddPortal(self):
        
        # Invalid parameters:
        # * country
        self.assertRaises(ValidationException, manage_addWSPortal, self.app, 'id_test2', 2, 'en', 'skin_test', 'post', 'http://mapserver', None)
        # * subdivisions
        self.assertRaises(ValidationException, manage_addWSPortal, self.app, 'id_test2', None, 'en', 'skin_test', 'post', 'http://mapserver', None)
        # * languages
        self.assertRaises(ValidationException, manage_addWSPortal, self.app, 'id_test2', 2, '', 'skin_test', 'post', 'http://mapserver', None)
        # * skin
        self.assertRaises(ValidationException, manage_addWSPortal, self.app, 'id_test2', 2, 'en', None, 'post', 'http://mapserver', None)
        # * moderation
        self.assertRaises(ValidationException, manage_addWSPortal, self.app, 'id_test2', 2, 'en', 'skin_test', None, 'http://mapserver', None)
        # * mapserver_url
        self.assertRaises(ValidationException, manage_addWSPortal, self.app, 'id_test2', 2, 'en', 'skin_test', 'post', None, None)

        # Normal creation is tested in base class

        # Duplicate zope ID
        self.assertRaises(Exception, manage_addWSPortal, self.app, 'id_test', 'title_test', 'en', True, 'country_test', 2, 'en', 'skin_test', 'post', None)

        # Duplicate database (country_test) are accepted. Uses the original database


def test_suite():
    suite = TestSuite()
    suite.addTest(makeSuite(WSPortalTest))
    return suite

