--
-- DDL for dictionaries
-- Author(s): Cristian Romanescu <cristian.romanescu@eaudeweb.ro>
-- This file contains the database structure common to both WatSan website and country portal.
-- Please manually keep both structure identical (through update scripts in production etc) because they are synchronizing.
--


--
-- Table: lex_upistype
--
DROP TABLE IF EXISTS lex_upistype CASCADE;
CREATE TABLE lex_upistype
(
	code character varying(4) NOT NULL,
	"name" character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_upistype PRIMARY KEY (code)
);
COMMENT ON TABLE lex_upistype IS 'Type of infrastructure stored in the UPIS table (Example: WP - water point, SF - sanitation facility, PWS - piped water scheme, UWS - underground water source, etc.)';
COMMENT ON COLUMN lex_upistype.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_upistype."name" IS 'Name in english';
COMMENT ON COLUMN lex_upistype.name2 IS 'Name in original language';



--
-- Table: lex_upisloctype
--
DROP TABLE IF EXISTS lex_upisloctype CASCADE;
CREATE TABLE lex_upisloctype
(
	code character varying(2) NOT NULL,
	"name" character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_upisloctype PRIMARY KEY (code)
);
COMMENT ON TABLE lex_upisloctype IS 'Type of place where the installation is located (code WP008, SF007)';
COMMENT ON COLUMN lex_upisloctype.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_upisloctype."name" IS 'Name in english';
COMMENT ON COLUMN lex_upisloctype.name2 IS 'Name in original language';



--
-- Table: lex_upismanprof
--
DROP TABLE IF EXISTS lex_upismanprof CASCADE;
CREATE TABLE lex_upismanprof
(
	code character varying(2) NOT NULL,
	"name" character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_upismanprof PRIMARY KEY (code)
);
COMMENT ON TABLE lex_upismanprof IS 'Water point manager profile (code WP010, SF008, PWS006)';
COMMENT ON COLUMN lex_upismanprof.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_upismanprof."name" IS 'Name in english';
COMMENT ON COLUMN lex_upismanprof.name2 IS 'Name in original language';



--
-- Table: lex_opb005
--
DROP TABLE IF EXISTS lex_opb005 CASCADE;
CREATE TABLE lex_opb005
(
	code character varying(2) NOT NULL,
	"name" character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_opb005 PRIMARY KEY (code)
);
COMMENT ON TABLE lex_opb005 IS 'Category of funding';
COMMENT ON COLUMN lex_opb005.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_opb005."name" IS 'Name in english';
COMMENT ON COLUMN lex_opb005.name2 IS 'Name in original language';



--
-- Table: lex_upisfinance
--
DROP TABLE IF EXISTS lex_upisfinance CASCADE;
CREATE TABLE lex_upisfinance
(
	code character varying(2) NOT NULL,
	"name" character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_upisfinance PRIMARY KEY (code)
);
COMMENT ON TABLE lex_upisfinance IS 'Source of financing (code WP0013, SF010)';
COMMENT ON COLUMN lex_upisfinance.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_upisfinance."name" IS 'Name in english';
COMMENT ON COLUMN lex_upisfinance.name2 IS 'Name in original language';



--
-- Table: lex_cooling
--
DROP TABLE IF EXISTS lex_cooling CASCADE;
CREATE TABLE lex_cooling (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cooling PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cooling IS 'Type of cooling system';
COMMENT ON COLUMN lex_cooling.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cooling."name" IS 'Name in english';
COMMENT ON COLUMN lex_cooling.name2 IS 'Name in original language';



--
-- Table: lex_loc015
--
DROP TABLE IF EXISTS lex_loc015 CASCADE;
CREATE TABLE lex_loc015 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_loc015 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_loc015 IS 'Urban / semi-urban / rural status';
COMMENT ON COLUMN lex_loc015.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_loc015."name" IS 'Name in english';
COMMENT ON COLUMN lex_loc015.name2 IS 'Name in original language';



--
-- Table: lex_loc016
--
DROP TABLE IF EXISTS lex_loc016 CASCADE;
CREATE TABLE lex_loc016 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_loc016 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_loc016 IS 'Type of habitat grouping of the locality';
COMMENT ON COLUMN lex_loc016.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_loc016."name" IS 'Name in english';
COMMENT ON COLUMN lex_loc016.name2 IS 'Name in original language';



--
-- Table: lex_loc021
--
DROP TABLE IF EXISTS lex_loc021 CASCADE;
CREATE TABLE lex_loc021 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_loc021 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_loc021 IS 'National rank of the locality for access to water';
COMMENT ON COLUMN lex_loc021.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_loc021."name" IS 'Name in english';
COMMENT ON COLUMN lex_loc021.name2 IS 'Name in original language';



--
-- Table: lex_loc041
--
DROP TABLE IF EXISTS lex_loc041 CASCADE;
CREATE TABLE lex_loc041 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_loc041 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_loc041 IS 'Main access to water';
COMMENT ON COLUMN lex_loc041.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_loc041."name" IS 'Name in english';
COMMENT ON COLUMN lex_loc041.name2 IS 'Name in original language';



--
-- Table: lex_loc043
--
DROP TABLE IF EXISTS lex_loc043 CASCADE;
CREATE TABLE lex_loc043 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_loc043 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_loc043 IS 'Locality served with a low voltage grid';
COMMENT ON COLUMN lex_loc043.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_loc043."name" IS 'Name in english';
COMMENT ON COLUMN lex_loc043.name2 IS 'Name in original language';



--
-- Table: lex_wp007
--
DROP TABLE IF EXISTS lex_wp007 CASCADE;
CREATE TABLE lex_wp007 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	ewp real NOT NULL DEFAULT 1,
	CONSTRAINT pk_lex_wp007 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp007 IS 'Type of water point';
COMMENT ON COLUMN lex_wp007.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp007."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp007.name2 IS 'Name in original language';
COMMENT ON COLUMN lex_wp007.ewp IS 'Number of Equivalent Water Points for each type of water point';



--
-- Table: lex_wp009
--
DROP TABLE IF EXISTS lex_wp009 CASCADE;
CREATE TABLE lex_wp009 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp009 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp009 IS 'Principal use of the water point';
COMMENT ON COLUMN lex_wp009.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp009."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp009.name2 IS 'Name in original language';



--
-- Table: lex_wp017
--
DROP TABLE IF EXISTS lex_wp017 CASCADE;
CREATE TABLE lex_wp017 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp017 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp017 IS 'Benchmarking of the water point by the users';
COMMENT ON COLUMN lex_wp017.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp017."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp017.name2 IS 'Name in original language';



--
-- Table: lex_wp051
--
DROP TABLE IF EXISTS lex_wp051 CASCADE;
CREATE TABLE lex_wp051 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp051 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp051 IS 'Functionality of the water point';
COMMENT ON COLUMN lex_wp051.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp051."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp051.name2 IS 'Name in original language';



--
-- Table: lex_wp052
--
DROP TABLE IF EXISTS lex_wp052 CASCADE;
CREATE TABLE lex_wp052 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp052 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp052 IS 'Reasons for non functionality';
COMMENT ON COLUMN lex_wp052.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp052."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp052.name2 IS 'Name in original language';



--
-- Table: lex_wp053
--
DROP TABLE IF EXISTS lex_wp053 CASCADE;
CREATE TABLE lex_wp053 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp053 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp053 IS 'Duration of non functionality';
COMMENT ON COLUMN lex_wp053.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp053."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp053.name2 IS 'Name in original language';



--
-- Table: lex_wp055
--
DROP TABLE IF EXISTS lex_wp055 CASCADE;
CREATE TABLE lex_wp055 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp055 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp055 IS 'Assessment of civil works on the water point';
COMMENT ON COLUMN lex_wp055.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp055."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp055.name2 IS 'Name in original language';



--
-- Table: lex_wp056
--
DROP TABLE IF EXISTS lex_wp056 CASCADE;
CREATE TABLE lex_wp056 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp056 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp056 IS 'Assessment of plumbering on the water point';
COMMENT ON COLUMN lex_wp056.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp056."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp056.name2 IS 'Name in original language';



--
-- Table: lex_wp057
--
DROP TABLE IF EXISTS lex_wp057 CASCADE;
CREATE TABLE lex_wp057 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp057 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp057 IS 'Assessment of hygiene around the water point';
COMMENT ON COLUMN lex_wp057.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp057."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp057.name2 IS 'Name in original language';



--
-- Table: lex_wp058
--
DROP TABLE IF EXISTS lex_wp058 CASCADE;
CREATE TABLE lex_wp058 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp058 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp058 IS 'Fencing of the water point';
COMMENT ON COLUMN lex_wp058.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp058."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp058.name2 IS 'Name in original language';



--
-- Table: lex_wp059
--
DROP TABLE IF EXISTS lex_wp059 CASCADE;
CREATE TABLE lex_wp059 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp059 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp059 IS 'Turbidity of water';
COMMENT ON COLUMN lex_wp059.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp059."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp059.name2 IS 'Name in original language';



--
-- Table: lex_wp060
--
DROP TABLE IF EXISTS lex_wp060 CASCADE;
CREATE TABLE lex_wp060 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp060 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp060 IS 'Taste of water';
COMMENT ON COLUMN lex_wp060.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp060."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp060.name2 IS 'Name in original language';



--
-- Table: lex_wp061
--
DROP TABLE IF EXISTS lex_wp061 CASCADE;
CREATE TABLE lex_wp061 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp061 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp061 IS 'Odor of water';
COMMENT ON COLUMN lex_wp061.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp061."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp061.name2 IS 'Name in original language';



--
-- Table: lex_wp062
--
DROP TABLE IF EXISTS lex_wp062 CASCADE;
CREATE TABLE lex_wp062 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp062 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp062 IS 'System of water treatment on the water point';
COMMENT ON COLUMN lex_wp062.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp062."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp062.name2 IS 'Name in original language';



--
-- Table: lex_wp063
--
DROP TABLE IF EXISTS lex_wp063 CASCADE;
CREATE TABLE lex_wp063 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp063 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp063 IS 'Functionality of the system of water treatment';
COMMENT ON COLUMN lex_wp063.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp063."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp063.name2 IS 'Name in original language';



--
-- Table: lex_wp064
--
DROP TABLE IF EXISTS lex_wp064 CASCADE;
CREATE TABLE lex_wp064 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp064 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp064 IS 'Modalities for the payment of water on the water point';
COMMENT ON COLUMN lex_wp064.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp064."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp064.name2 IS 'Name in original language';



--
-- Table: lex_wp065
--
DROP TABLE IF EXISTS lex_wp065 CASCADE;
CREATE TABLE lex_wp065 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp065 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp065 IS 'Seasonability of the payment of water on the water point';
COMMENT ON COLUMN lex_wp065.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp065."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp065.name2 IS 'Name in original language';



--
-- Table: lex_wp066
--
DROP TABLE IF EXISTS lex_wp066 CASCADE;
CREATE TABLE lex_wp066 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp066 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp066 IS 'Brand/Type of the handpump';
COMMENT ON COLUMN lex_wp066.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp066."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp066.name2 IS 'Name in original language';



--
-- Table: lex_wp067
--
DROP TABLE IF EXISTS lex_wp067 CASCADE;
CREATE TABLE lex_wp067 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp067 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp067 IS 'Functionality of the handpump';
COMMENT ON COLUMN lex_wp067.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp067."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp067.name2 IS 'Name in original language';



--
-- Table: lex_wp071
--
DROP TABLE IF EXISTS lex_wp071 CASCADE;
CREATE TABLE lex_wp071 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp071 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp071 IS 'Functionality of the water metering system';
COMMENT ON COLUMN lex_wp071.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp071."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp071.name2 IS 'Name in original language';



--
-- Table: lex_wp074
--
DROP TABLE IF EXISTS lex_wp074 CASCADE;
CREATE TABLE lex_wp074 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp074 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp074 IS 'Protection area against contamination by latrines';
COMMENT ON COLUMN lex_wp074.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp074."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp074.name2 IS 'Name in original language';



--
-- Table: lex_wp075
--
DROP TABLE IF EXISTS lex_wp075 CASCADE;
CREATE TABLE lex_wp075 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp075 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp075 IS 'Drying up of the water point';
COMMENT ON COLUMN lex_wp075.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp075."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp075.name2 IS 'Name in original language';



--
-- Table: lex_wp076
--
DROP TABLE IF EXISTS lex_wp076 CASCADE;
CREATE TABLE lex_wp076 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp076 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp076 IS 'Closing system on the well';
COMMENT ON COLUMN lex_wp076.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp076."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp076.name2 IS 'Name in original language';



--
-- Table: lex_wp077
--
DROP TABLE IF EXISTS lex_wp077 CASCADE;
CREATE TABLE lex_wp077 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp077 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp077 IS 'Water abstraction system on the well';
COMMENT ON COLUMN lex_wp077.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp077."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp077.name2 IS 'Name in original language';



--
-- Table: lex_wp080
--
DROP TABLE IF EXISTS lex_wp080 CASCADE;
CREATE TABLE lex_wp080 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wp080 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wp080 IS 'Sale unit';
COMMENT ON COLUMN lex_wp080.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wp080."name" IS 'Name in english';
COMMENT ON COLUMN lex_wp080.name2 IS 'Name in original language';



--
-- Table: lex_sf006
--
DROP TABLE IF EXISTS lex_sf006 CASCADE;
CREATE TABLE lex_sf006 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf006 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf006 IS 'Type of sanitation facility';
COMMENT ON COLUMN lex_sf006.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf006."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf006.name2 IS 'Name in original language';



--
-- Table: lex_sf012
--
DROP TABLE IF EXISTS lex_sf012 CASCADE;
CREATE TABLE lex_sf012 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf012 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf012 IS 'Type of building materials';
COMMENT ON COLUMN lex_sf012.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf012."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf012.name2 IS 'Name in original language';



--
-- Table: lex_sf013
--
DROP TABLE IF EXISTS lex_sf013 CASCADE;
CREATE TABLE lex_sf013 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf013 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf013 IS 'Type of ground';
COMMENT ON COLUMN lex_sf013.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf013."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf013.name2 IS 'Name in original language';



--
-- Table: lex_sf021
--
DROP TABLE IF EXISTS lex_sf021 CASCADE;
CREATE TABLE lex_sf021 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf021 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf021 IS 'Availability of water ate the sanitation facility';
COMMENT ON COLUMN lex_sf021.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf021."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf021.name2 IS 'Name in original language';



--
-- Table: lex_sf050
--
DROP TABLE IF EXISTS lex_sf050 CASCADE;
CREATE TABLE lex_sf050 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf050 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf050 IS 'Functionality of the sanitation facility';
COMMENT ON COLUMN lex_sf050.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf050."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf050.name2 IS 'Name in original language';



--
-- Table: lex_sf051
--
DROP TABLE IF EXISTS lex_sf051 CASCADE;
CREATE TABLE lex_sf051 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf051 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf051 IS 'Reasons for non functionality';
COMMENT ON COLUMN lex_sf051.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf051."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf051.name2 IS 'Name in original language';



--
-- Table: lex_sf052
--
DROP TABLE IF EXISTS lex_sf052 CASCADE;
CREATE TABLE lex_sf052 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf052 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf052 IS 'Duration of non functionality';
COMMENT ON COLUMN lex_sf052.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf052."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf052.name2 IS 'Name in original language';



--
-- Table: lex_sf053
--
DROP TABLE IF EXISTS lex_sf053 CASCADE;
CREATE TABLE lex_sf053 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf053 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf053 IS 'Assessment of civil works on the sanitation facility';
COMMENT ON COLUMN lex_sf053.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf053."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf053.name2 IS 'Name in original language';



--
-- Table: lex_sf054
--
DROP TABLE IF EXISTS lex_sf054 CASCADE;
CREATE TABLE lex_sf054 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf054 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf054 IS 'Assessment of plumbering on the sanitation facility';
COMMENT ON COLUMN lex_sf054.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf054."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf054.name2 IS 'Name in original language';



--
-- Table: lex_sf055
--
DROP TABLE IF EXISTS lex_sf055 CASCADE;
CREATE TABLE lex_sf055 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf055 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf055 IS 'Assessment of cleanliness on the sanitation facility';
COMMENT ON COLUMN lex_sf055.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf055."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf055.name2 IS 'Name in original language';



--
-- Table: lex_sf056
--
DROP TABLE IF EXISTS lex_sf056 CASCADE;
CREATE TABLE lex_sf056 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_sf056 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_sf056 IS 'Modalities for the payment on the sanitation facility';
COMMENT ON COLUMN lex_sf056.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_sf056."name" IS 'Name in english';
COMMENT ON COLUMN lex_sf056.name2 IS 'Name in original language';



--
-- Table: lex_pws005
--
DROP TABLE IF EXISTS lex_pws005 CASCADE;
CREATE TABLE lex_pws005 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pws005 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pws005 IS 'Ownership of the scheme';
COMMENT ON COLUMN lex_pws005.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pws005."name" IS 'Name in english';
COMMENT ON COLUMN lex_pws005.name2 IS 'Name in original language';



--
-- Table: lex_pws007
--
DROP TABLE IF EXISTS lex_pws007 CASCADE;
CREATE TABLE lex_pws007 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pws007 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pws007 IS 'Contracting arrangement';
COMMENT ON COLUMN lex_pws007.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pws007."name" IS 'Name in english';
COMMENT ON COLUMN lex_pws007.name2 IS 'Name in original language';



--
-- Table: lex_pws020
--
DROP TABLE IF EXISTS lex_pws020 CASCADE;
CREATE TABLE lex_pws020 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pws020 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pws020 IS 'Functionality of the scheme';
COMMENT ON COLUMN lex_pws020.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pws020."name" IS 'Name in english';
COMMENT ON COLUMN lex_pws020.name2 IS 'Name in original language';



--
-- Table: lex_pws024
--
DROP TABLE IF EXISTS lex_pws024 CASCADE;
CREATE TABLE lex_pws024 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pws024 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pws024 IS 'Energy source(s) configuration';
COMMENT ON COLUMN lex_pws024.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pws024."name" IS 'Name in english';
COMMENT ON COLUMN lex_pws024.name2 IS 'Name in original language';



--
-- Table: lex_pws025
--
DROP TABLE IF EXISTS lex_pws025 CASCADE;
CREATE TABLE lex_pws025 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pws025 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pws025 IS 'Extent of piped scheme';
COMMENT ON COLUMN lex_pws025.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pws025."name" IS 'Name in english';
COMMENT ON COLUMN lex_pws025.name2 IS 'Name in original language';



--
-- Table: lex_pws027
--
DROP TABLE IF EXISTS lex_pws027 CASCADE;
CREATE TABLE lex_pws027 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pws027 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pws027 IS 'Type of water resource abstracted';
COMMENT ON COLUMN lex_pws027.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pws027."name" IS 'Name in english';
COMMENT ON COLUMN lex_pws027.name2 IS 'Name in original language';



--
-- Table: lex_pwi003
--
DROP TABLE IF EXISTS lex_pwi003 CASCADE;
CREATE TABLE lex_pwi003 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwi003 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwi003 IS 'Category of pipe';
COMMENT ON COLUMN lex_pwi003.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwi003."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwi003.name2 IS 'Name in original language';



--
-- Table: lex_pwp004
--
DROP TABLE IF EXISTS lex_pwp004 CASCADE;
CREATE TABLE lex_pwp004 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwp004 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwp004 IS 'Category of water source';
COMMENT ON COLUMN lex_pwp004.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwp004."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwp004.name2 IS 'Name in original language';



--
-- Table: lex_pwp005
--
DROP TABLE IF EXISTS lex_pwp005 CASCADE;
CREATE TABLE lex_pwp005 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwp005 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwp005 IS 'Category of pump';
COMMENT ON COLUMN lex_pwp005.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwp005."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwp005.name2 IS 'Name in original language';



--
-- Table: lex_pwp007
--
DROP TABLE IF EXISTS lex_pwp007 CASCADE;
CREATE TABLE lex_pwp007 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwp007 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwp007 IS 'Category of energy required for the pump';
COMMENT ON COLUMN lex_pwp007.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwp007."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwp007.name2 IS 'Name in original language';



--
-- Table: lex_pwe003
--
DROP TABLE IF EXISTS lex_pwe003 CASCADE;
CREATE TABLE lex_pwe003 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwe003 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwe003 IS 'Category of energy source';
COMMENT ON COLUMN lex_pwe003.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwe003."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwe003.name2 IS 'Name in original language';



--
-- Table: lex_pwss003
--
DROP TABLE IF EXISTS lex_pwss003 CASCADE;
CREATE TABLE lex_pwss003 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwss003 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwss003 IS 'Category of reservoir';
COMMENT ON COLUMN lex_pwss003.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwss003."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwss003.name2 IS 'Name in original language';



--
-- Table: lex_pwss004
--
DROP TABLE IF EXISTS lex_pwss004 CASCADE;
CREATE TABLE lex_pwss004 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwss004 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwss004 IS 'Building material of the tank';
COMMENT ON COLUMN lex_pwss004.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwss004."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwss004.name2 IS 'Name in original language';



--
-- Table: lex_pwt002
--
DROP TABLE IF EXISTS lex_pwt002 CASCADE;
CREATE TABLE lex_pwt002 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_pwt002 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_pwt002 IS 'Type of water treatment';
COMMENT ON COLUMN lex_pwt002.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_pwt002."name" IS 'Name in english';
COMMENT ON COLUMN lex_pwt002.name2 IS 'Name in original language';



--
-- Table: lex_dry004
--
DROP TABLE IF EXISTS lex_dry004 CASCADE;
CREATE TABLE lex_dry004 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_dry004 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_dry004 IS 'Category of organization';
COMMENT ON COLUMN lex_dry004.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_dry004."name" IS 'Name in english';
COMMENT ON COLUMN lex_dry004.name2 IS 'Name in original language';



--
-- Table: lex_cge004
--
DROP TABLE IF EXISTS lex_cge004 CASCADE;
CREATE TABLE lex_cge004 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cge004 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cge004 IS 'Fuel type';
COMMENT ON COLUMN lex_cge004.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cge004."name" IS 'Name in english';
COMMENT ON COLUMN lex_cge004.name2 IS 'Name in original language';



--
-- Table: lex_cge007
--
DROP TABLE IF EXISTS lex_cge007 CASCADE;
CREATE TABLE lex_cge007 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cge007 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cge007 IS 'Nominal voltage and nb. of phases of alternator';
COMMENT ON COLUMN lex_cge007.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cge007."name" IS 'Name in english';
COMMENT ON COLUMN lex_cge007.name2 IS 'Name in original language';



--
-- Table: lex_cge008
--
DROP TABLE IF EXISTS lex_cge008 CASCADE;
CREATE TABLE lex_cge008 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cge008 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cge008 IS 'Nominal frequence of alternator (Hz)';
COMMENT ON COLUMN lex_cge008.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cge008."name" IS 'Name in english';
COMMENT ON COLUMN lex_cge008.name2 IS 'Name in original language';



--
-- Table: lex_cpv004
--
DROP TABLE IF EXISTS lex_cpv004 CASCADE;
CREATE TABLE lex_cpv004 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cpv004 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cpv004 IS 'Cell technology';
COMMENT ON COLUMN lex_cpv004.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cpv004."name" IS 'Name in english';
COMMENT ON COLUMN lex_cpv004.name2 IS 'Name in original language';



--
-- Table: lex_cin006
--
DROP TABLE IF EXISTS lex_cin006 CASCADE;
CREATE TABLE lex_cin006 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cin006 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cin006 IS 'Type of modulation';
COMMENT ON COLUMN lex_cin006.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cin006."name" IS 'Name in english';
COMMENT ON COLUMN lex_cin006.name2 IS 'Name in original language';



--
-- Table: lex_cpp004
--
DROP TABLE IF EXISTS lex_cpp004 CASCADE;
CREATE TABLE lex_cpp004 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cpp004 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cpp004 IS 'Type of pump';
COMMENT ON COLUMN lex_cpp004.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cpp004."name" IS 'Name in english';
COMMENT ON COLUMN lex_cpp004.name2 IS 'Name in original language';



--
-- Table: lex_chp005
--
DROP TABLE IF EXISTS lex_chp005 CASCADE;
CREATE TABLE lex_chp005 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_chp005 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_chp005 IS 'Type of handpump';
COMMENT ON COLUMN lex_chp005.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_chp005."name" IS 'Name in english';
COMMENT ON COLUMN lex_chp005.name2 IS 'Name in original language';



--
-- Table: lex_cwm005
--
DROP TABLE IF EXISTS lex_cwm005 CASCADE;
CREATE TABLE lex_cwm005 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cwm005 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cwm005 IS 'Type of water meter';
COMMENT ON COLUMN lex_cwm005.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cwm005."name" IS 'Name in english';
COMMENT ON COLUMN lex_cwm005.name2 IS 'Name in original language';



--
-- Table: lex_cwm006
--
DROP TABLE IF EXISTS lex_cwm006 CASCADE;
CREATE TABLE lex_cwm006 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_cwm006 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_cwm006 IS 'Precision class';
COMMENT ON COLUMN lex_cwm006.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_cwm006."name" IS 'Name in english';
COMMENT ON COLUMN lex_cwm006.name2 IS 'Name in original language';



--
-- Table: lex_uws005
--
DROP TABLE IF EXISTS lex_uws005 CASCADE;
CREATE TABLE lex_uws005 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_uws005 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_uws005 IS 'Type of source';
COMMENT ON COLUMN lex_uws005.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_uws005."name" IS 'Name in english';
COMMENT ON COLUMN lex_uws005.name2 IS 'Name in original language';



--
-- Table: lex_uws012
--
DROP TABLE IF EXISTS lex_uws012 CASCADE;
CREATE TABLE lex_uws012 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_uws012 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_uws012 IS 'Catched aquifer';
COMMENT ON COLUMN lex_uws012.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_uws012."name" IS 'Name in english';
COMMENT ON COLUMN lex_uws012.name2 IS 'Name in original language';



--
-- Table: lex_wqd003
--
DROP TABLE IF EXISTS lex_wqd003 CASCADE;
CREATE TABLE lex_wqd003 (
	code character varying (2) NOT NULL,
	name character varying NOT NULL,
	name2 character varying NOT NULL,
	CONSTRAINT pk_lex_wqd003 PRIMARY KEY (code)
);

COMMENT ON TABLE lex_wqd003 IS 'Parameter measured and measurement unit';
COMMENT ON COLUMN lex_wqd003.code IS 'Dictionary unique code. Primary key';
COMMENT ON COLUMN lex_wqd003."name" IS 'Name in english';
COMMENT ON COLUMN lex_wqd003.name2 IS 'Name in original language';

