--
-- Data for technical catalogs table
-- Author(s): Cristian Romanescu <cristian.romanescu@eaudeweb.ro>
--


-- Data: lex_cat_catalog
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000001', 'Catalog of generators', TRUE, TRUE, '2010-07-19 18:51:48.99325', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000002', 'Catalog of thermal engines', TRUE, TRUE, '2010-07-19 18:52:05.80877', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000003', 'Catalog of solar photovoltaic panel', TRUE, TRUE, '2010-07-19 18:52:16.488856', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000004', 'Catalog of DC/AC pump inverters for solar applications', TRUE, TRUE, '2010-07-19 18:52:35.032754', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000005', 'Catalog of electrical or mechanical pumps', TRUE, TRUE, '2010-07-19 18:52:47.264856', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000006', 'Catalog of hand pumps', TRUE, TRUE, '2010-07-19 18:53:03.904799', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000007', 'Catalog of wind pumps', TRUE, TRUE, '2010-07-19 18:53:13.896857', 'cristiroma');
INSERT INTO t_cat_catalog (id_catalog, name, enabled, reference, created, author) VALUES ('REF000008', 'Catalog of water meters', TRUE, TRUE, '2010-07-19 18:53:13.996857', 'cristiroma');



-- Data: lex_cat_attribute
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000001', 'Fuel type', false, false, false, false, true, false, false, 'LexCGE004', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000002', 'Cooling system', false, false, false, false, true, false, false, 'LexCooling', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000003', 'Nominal engine speed (rpm)', false, true, false, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000004', 'Nominal voltage and nb. of phases of alternator', false, false, false, false, true, false, false, 'LexCGE007', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000005', 'Nominal frequence of alternator (Hz)', false, false, false, false, true, false, false, 'LexCGE008', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000006', 'Nominal electric power at cosinus phi = 0,8 (kVA)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000007', 'Fuel consumption at 3/4 of nominal power (l/h)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000008', 'Engine reference', true, false, false, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000009', 'Alternator reference', true, false, false, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000010', 'Number of cylinders', false, true, false, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000011', 'Capacity (cm3)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000012', 'Quietizer', false, false, false, true, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000013', 'Fuel tank capacity (l)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000014', 'Nominal mechanical power (kW)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000015', 'Cell technology', false, false, false, false, true, false, false, 'LexCPV004', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000016', 'Peak power (Wp)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000017', 'Power (KVA)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000018', 'DC input voltage (V)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000019', 'Type of modulation', false, false, false, false, true, false, false, 'LexCIN006', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000020', 'Type of pump', false, false, false, false, true, false, false, 'LexCPP004', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000021', 'Overall pump diameter (mm)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000022', 'DC operating voltage (V)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000023', 'AC operating voltage (V)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000024', 'Nominal total manometric head (m)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000025', 'Nominal yield (m3/h)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000026', 'Nominal speed (trs/mn)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000027', 'Type of handpump', false, false, false, false, true, false, false, 'LexCHP005', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000028', 'Maximum operating depth (m)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000029', 'Mean yield (m3/h)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000030', 'Country of origin', true, false, false, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000031', 'Number of blades', false, true, false, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000032', 'Rotor diameter', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000033', 'Rotor height to ground', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000034', 'Nominal wind speed (m/s)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000035', 'Starting wind speed (m/s)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000036', 'Nominal power (W)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000037', 'Type of water meter', true, false, false, false, true, false, false, 'LexCWM005', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000038', 'Precision class', false, false, false, false, true, false, false, 'LexCWM006', true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000039', 'Nominal diameter (mm)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000040', 'Nominal pressure (bars)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000041', 'Transition yield (m3/h)', false, false, true, false, false, false, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000042', 'Photo', false, false, false, false, false, false, true, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');
INSERT INTO t_cat_attribute (id_attribute, name, is_string, is_integer, is_real, is_bool, is_lexicon, is_url, is_picture, lexicon_klass, enabled, reference, created, author) VALUES ('REF000043', 'Constructor datasheet', false, false, false, false, false, true, false, NULL, true, true, '2010-07-29 09:59:18.16768', 'cristiroma');



-- Data lex_cat_catalog_dd
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000009', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000011', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000002', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000008', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000007', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000013', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000001', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000006', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000003', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000005', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000004', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000010', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000001', 'REF000012', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000011', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000002', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000007', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000013', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000001', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000003', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000014', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000010', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000002', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000003', 'REF000015', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000003', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000003', 'REF000016', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000004', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000004', 'REF000018', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000004', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000004', 'REF000017', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000004', 'REF000019', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000023', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000022', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000026', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000024', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000025', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000021', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000005', 'REF000020', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000006', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000006', 'REF000030', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000006', 'REF000028', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000006', 'REF000029', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000006', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000006', 'REF000027', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000030', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000036', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000034', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000031', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000032', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000033', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000007', 'REF000035', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000043', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000030', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000039', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000040', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000025', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000042', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000038', true);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000041', false);
INSERT INTO t_cat_catalog_dd (id_catalog, id_attribute, show_in_overview) VALUES ('REF000008', 'REF000037', false);
