--
-- DDL for country table
-- Author(s): Cristian Romanescu <cristian.romanescu@eaudeweb.ro>
-- This file contains the database structure common to both WatSan website and country portal.
-- Please manually keep both structure identical (through update scripts in production etc).
--



--
-- Table: t_adcountry
--
DROP TABLE IF EXISTS t_adcountry CASCADE;
CREATE TABLE t_adcountry
(
	adcncodex character(2) NOT NULL,
	adcnname character varying NOT NULL,
	adcnname2 character varying,
	adcnnameov character varying NOT NULL,
	adcnurlwat character varying,

	total_population integer,
	rural_population integer,
	urban_population integer,
	water_access_rural real,
	water_access_rural_byconn real,
	water_access_urban real,
	water_access_urban_byconn real,
	sanitation_access_rural real,
	sanitation_access_urban real,
	"year" integer,

	CONSTRAINT pk_t_adcountry PRIMARY KEY (adcncodex)
);

CREATE UNIQUE INDEX t_adcountry_idx_name ON t_adcountry USING btree (adcnname);

COMMENT ON TABLE t_adcountry IS 'List of countries from Africa (CTRY)';
COMMENT ON COLUMN t_adcountry.adcncodex IS 'Country ISO 3166-2 code (CTY001)';
COMMENT ON COLUMN t_adcountry.adcnname IS 'Original version of the name in country language';
COMMENT ON COLUMN t_adcountry.adcnnameov IS 'Country name in english';
COMMENT ON COLUMN t_adcountry.adcnurlwat IS 'URL of the country portal';
COMMENT ON COLUMN t_adcountry.total_population IS 'Total country population (CTY002)';
COMMENT ON COLUMN t_adcountry.rural_population IS 'Rural and semi-urban population (CTY003)';
COMMENT ON COLUMN t_adcountry.urban_population IS 'Population in urban areas (CTY004)';
COMMENT ON COLUMN t_adcountry.water_access_rural IS 'Access rate to water in rural and semi-urban areas (CTY005)';
COMMENT ON COLUMN t_adcountry.water_access_rural_byconn IS 'Access rate to water by connection in rural and semi-urban areas (CTY006)';
COMMENT ON COLUMN t_adcountry.water_access_urban IS 'Access rate to water in urban areas (CTY007)';
COMMENT ON COLUMN t_adcountry.water_access_urban_byconn IS 'Access rate to water by connection in urban areas (CTY008)';
COMMENT ON COLUMN t_adcountry.sanitation_access_rural IS 'Access rate to sanitation in rural and semi-urban areas (CTY009)';
COMMENT ON COLUMN t_adcountry.sanitation_access_urban IS 'Access rate to sanitation in urban areas (CTY010)';
COMMENT ON COLUMN t_adcountry.year IS 'Year when statistics above applies (CTY011)';
