from zope import interface
from zope import component

from Products.Naaya.interfaces import INySite
from Products.NaayaCore.PortletsTool.interfaces import INyPortlet
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile

class PortalLinksPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Portal useful links'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('zpt/portlets/useful_links', globals(),
                                     'watsan.portal.useful_links')

class NewsArticlesPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'News&Articles navigation'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('zpt/portlets/news_articles', globals(),
                                     'watsan.portal.news_articles')

class FacilitiesSearchPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Facilities search'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Facilities/zpt/portlets/search', globals(),
                                     'watsan.portal.facilities.search')

class WaterpointsNavigationPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Water points navigation menu'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Facilities/zpt/portlets/waterpoints', globals(),
                                     'watsan.portal.waterpoints.navigation')

class SanitationsNavigationPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Sanitation facilities navigation menu'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Facilities/zpt/portlets/sanitations', globals(),
                                     'watsan.portal.sanitations.navigation')

class PWSNavigationPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Piped water schemes navigation menu'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Facilities/zpt/portlets/pws', globals(),
                                     'watsan.portal.pws.navigation')

class IWRMNavigationPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'IWRM navigation'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('IWRM/zpt/portlets/navigation', globals(),
                                     'watsan.portal.iwrm.navigation')

class ProgramProgramPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Programs sidebar program navigation'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Programs/zpt/portlets/program', globals(),
                                     'watsan.portal.programs.program')


class ProgramsNavigationPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Programs sidebar navigation'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Programs/zpt/portlets/navigation', globals(),
                                     'watsan.portal.programs.navigation')

class ResourcesNavigationPortlet(object):
    interface.implements(INyPortlet)
    component.adapts(INySite)

    title = 'Resources navigation'

    def __init__(self, site):
        self.site = site

    def __call__(self, context, position):
        macro = self.site.getPortletsTool()._get_macro(position)
        return self.template.__of__(context)(macro=macro)

    template = NaayaPageTemplateFile('Resources/zpt/portlets/navigation', globals(),
                                     'watsan.portal.resources.navigation')