# WatSan Platform - Rapid development of national water and sanitation internet portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
from ws.common.utilities import country_list

import transaction
import zLOG

import WSPortal
from Products.Naaya import NySite
from Products.WSPortal import constants

__doc__ = """ This Zope product represents the WatSan country portal. See specifications for more details on this component"""
__version__ = '0.0.1'


def watsan_country_list():
    return country_list()


def initialize(context):
    """ 
        Product initialization method
        @param context: Zope server context 
    """
    app = context._ProductContext__app
    app.watsan_country_list = country_list

    try:
        context.registerClass(
            WSPortal.WSPortal,
            constructors = (
                WSPortal.manage_addWSPortal_html,
                WSPortal.manage_addWSPortal),
        )
    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        zLOG.LOG(__name__, zLOG.ERROR, 'An error occurred during product initialization. The WatSan Website will not be available', error = (type, val, tb), reraise=True)
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb
        
#Monkey patch for GChartWrapper 0.9
import sys
import GChartWrapper
GChartWrapper.constants.TYPES += ('bvo',)
sys.modules['GChartWrapper.GChart'].TYPES = GChartWrapper.constants.TYPES