# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cornel Nitu, Eau de Web
# Cristian Romanescu, Eau de Web

#Python imports

#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder, addNyFolder
from Products.NaayaForum.NyForum import addNyForum

#WatSAN imports
from Products.WSPortal.Resources.WSPortalDirectory import create_wsportaldirectory_object_callback
from Products.WSPortal.Resources.WSPortalGalleries import create_wsportalgalleries_object_callback
from Products.WSPortal.Resources.WSPortalMultimedia import create_wsportalmultimedia_object_callback
from ws.common.catalogs.Catalogs import create_catalogs_object_callback

def create_wsportalresources_object_callback(parent, id, contributor):
    ob = WSPortalResources(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

class WSPortalResources(NyFolder):
    """ Programs section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ """
        site = self.getSite()
        portlets_tool = site.getPortletsTool()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]
        portlets_tool.assign_portlet(location, position='left', portlet_id='resources_navigation', inherit=True)
        
        #resources directory content
        addNyFolder(self, id='multimedia', callback=create_wsportalmultimedia_object_callback, title='Multimedia library')
        addNyFolder(self.multimedia, id='photos', callback=create_wsportalgalleries_object_callback, title='Photo galleries')

        addNyFolder(self, id='directory', callback=create_wsportaldirectory_object_callback, title='Country stakeholder directory')
        addNyFolder(self, id='technical_catalogs', callback=create_catalogs_object_callback, title='Technical catalogs')
        addNyForum(self, 'forum', 'Discussion forum', 'WatSan country portal thematic discussion board.', categories=['Programs', 'Localities', 'FAQ'])

    def index_html(self, REQUEST):
        """ folder index """
        return self._index(REQUEST)

    _index = NaayaPageTemplateFile('zpt/index', globals(), 'ws_resources_index')

InitializeClass(WSPortalResources)

