from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder


def create_wsportalmultimedia_object_callback(parent, id, contributor):
    ob = WSPortalMultimedia(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

class WSPortalMultimedia(NyFolder):
    """ Multimedia section of the portal """

    security = ClassSecurityInfo()

    def index_html(self, REQUEST):
        """ galleries index """
        return self._index(REQUEST)

    security.declarePublic('getPhotos')
    def getPhotos(self, gallery='', index=2):
        """ """
        gallery_ob = getattr(self.photos, gallery, None)
        catalog = self.getCatalogTool()
        if gallery_ob:
            path = gallery_ob.absolute_url(1)
        else:
            path = self.absolute_url(1)
        photos = catalog.getCatalogedObjects(meta_type='Naaya Photo', path=path)
        try:
            return photos[:index]
        except IndexError:
            return None

    _index = NaayaPageTemplateFile('zpt/multimedia/index', globals(), 'ws_multimedia_index')

InitializeClass(WSPortalMultimedia)
