#Python imports
import os

#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

#Watsan imports
from Products.WSPortal import __file__ as wsportal_file
from Products.NaayaPhotoArchive.NyPhotoGallery import manage_addNyPhotoGallery

def create_wsportalgalleries_object_callback(parent, id, contributor):
    ob = WSPortalGalleries(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.load_galleries()
    ob.after_setObject()
    return ob

class WSPortalGalleries(NyFolder):
    """ Directory section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('load_galleries')
    def load_galleries(self, *args, **kwargs):
        """
            Load the initial galleries
        """
        manage_addNyPhotoGallery(self, id='subdivisions', title='Subdivisions')
        manage_addNyPhotoGallery(self, id='localities', title='Localities')
        manage_addNyPhotoGallery(self, id='waterpoints', title='Water points')
        manage_addNyPhotoGallery(self, id='piped_water_schemes', title='Piped water schemes')
        manage_addNyPhotoGallery(self, id='facilities', title='Sanitation facilities')
        manage_addNyPhotoGallery(self, id='organisations', title='Organisations')
        manage_addNyPhotoGallery(self, id='programs', title='Programs')
        manage_addNyPhotoGallery(self, id='portal_galleries', title='Portal photos')
        manage_addNyPhotoGallery(self, id='technical_catalogs', title='Technical catalogs')

        # Install default carousel photos
        self.portal_galleries.addNyPhotoFolder(id='carousel', title='Carousel images')
        base_dir = os.path.join(os.path.dirname(wsportal_file), 'media', 'images', 'carousel')
        photos = os.listdir(base_dir)
        for photo in photos:
            file_path = os.path.join(base_dir, photo)
            if os.path.isfile(file_path ):
                file = open(file_path).read()
                self.portal_galleries.carousel.addNyPhoto(id=photo, title='Carousel sample image', file=file)


    security.declarePublic('getLastPhoto')
    def getLastPhoto(self, gallery):
        """ """
        catalog = self.getCatalogTool()
        photos = catalog.getCatalogedObjects(meta_type='Naaya Photo', path=gallery.absolute_url(1))
        try:
            return photos[0]
        except IndexError:
            return None

    #def get_gallery_localities(self):
    #    return self.localities

    def get_gallery_waterpoints(self):
        return self.water_points

    def get_gallery_sanitation_facilities(self):
        return self.sanitation_facilities

    def get_gallery_organisations(self):
        return self.organisations

    def index_html(self, REQUEST):
        """ galleries index """
        return self._index(REQUEST)

    _index = NaayaPageTemplateFile('zpt/galleries/index', globals(), 'ws_galleries_index')
InitializeClass(WSPortalGalleries)
