#Python imports
from formencode import validators

#Zope imports
import zLOG
from AccessControl.SecurityInfo import ClassSecurityInfo
from AccessControl.Permissions import view
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

#Watsan imports
from ws.common.sql.queries import Organisation as organisation_queries
from ws.common.sql.mappings.Country import Country
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from ws.common.sql.mappings import Organisation as organisation_models
from ws.common.sql.queries import Access as access_query
from ws.common.utilities.photo_upload.PhotoUpload import PhotoUpload
from Products.WSPortal import constants
import forms

def create_wsportaldirectory_object_callback(parent, id, contributor):
    ob = WSPortalDirectory(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

class WSPortalDirectory(NyFolder):
    """ Directory section of the portal """

    security = ClassSecurityInfo()

    _listing = NaayaPageTemplateFile('zpt/directory/organisations_list', globals(), 'ws_organisations_list')
    security.declareProtected(view, 'listing')
    def listing(self, REQUEST):
        """ organisations list """
        session = self.get_db_session()
        items = organisation_queries.filter_organisations(session,
                                    text=REQUEST.get('q', ''),
                                    type=REQUEST.get('type', ''),
                                    country=REQUEST.get('country', ''),
                                    sort_on=REQUEST.get('sort', 'adorname'),
                                    sort_order=REQUEST.get('order', True))
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)

        types = organisation_queries.get_existing_types(session)
        types = [(item[0], item[1]) for item in types if item]

        countries = organisation_queries.get_existing_countries(session)
        countries = [item[0] for item in countries if item]

        return self._listing(REQUEST, organisations=items, countries=countries, types=types)


    security.declareProtected(view, 'index_html')
    index_html = listing


    _add = NaayaPageTemplateFile('zpt/directory/organisation_add', globals(), 'ws_organisation_add')
    security.declareProtected(constants.MANAGE_ORGANISATION, 'add')
    def add(self, REQUEST):
        """ add an organisation """
        error = None
        success = False
        session = self.get_db_session()
        types = organisation_queries.get_types(session)
        country = session.query(Country).filter_by(adcncodex=self.country_code.upper()).one()
        if REQUEST.form.has_key('btn-add-organisation'):
            try:
                form = forms.OrganisationForm.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                if REQUEST.get('country_switch', '') == self.country_code:
                    form['adorcountry'] = country.adcnname
                    locality_name = REQUEST.get('adorcity', '')
                    try:
                        locality = access_query.get_locality_by_name(session, locality_name)
                        form['adorcity'] = locality.adlocode
                    except:
                        zLOG.LOG(__name__, zLOG.WARNING, '    * Not found locality with name %s"' % locality_name)

                organisation = organisation_models.Organisation(**form)
                organisation.adorupwho = REQUEST.AUTHENTICATED_USER.getUserName()
                session.add(organisation)
                session.flush()

                #add photo
                file = REQUEST.form.get('adorlogo', None)
                if file:
                    photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/organisations',
                                                album_id=str(organisation.adorcode),
                                                album_title=form['adorname'],
                                                context=self)
                    organisation.adorlogo = photo_gallery.add_photo(title=form['adorname'], file=file)
                    session.merge(organisation)
                return REQUEST.RESPONSE.redirect('%s/view?id=%s' % (self.absolute_url(), organisation.adorcode))

        default = self.default_coordinates()
        adorhqx = REQUEST.get('adorhqx', default['longitude'])
        adorhqy = REQUEST.get('adorhqy', default['latitude'])
        zoom = REQUEST.get('zoom', self.default_zoom)

        return self._add(REQUEST, types=types, error=error, success=success, adorhqx=adorhqx, adorhqy=adorhqy, zoom=zoom, country=country)

    def getLogo(self, organisation):
        """ Returns organisation logo """
        photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/organisations',
                                    album_id=str(organisation.adorcode),
                                    album_title=organisation.adorname,
                                    context=self)
        return photo_gallery.get_photo(organisation.adorlogo)

    _edit = NaayaPageTemplateFile('zpt/directory/organisation_edit', globals(), 'ws_organisation_edit')
    security.declareProtected(constants.MANAGE_ORGANISATION, 'edit')
    def edit(self, REQUEST):
        """ edit organisation """
        session = self.get_db_session()
        error = None
        success = False
        types = organisation_queries.get_types(session)
        organisation = organisation_queries.get_organisation(session, REQUEST.get('id'))
        country = session.query(Country).filter_by(adcncodex=self.country_code.upper()).one()

        photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/organisations',
                                    album_id=str(organisation.adorcode),
                                    album_title=organisation.adorname,
                                    context=self)

        if REQUEST.form.has_key('btn-edit-organisation') or REQUEST.form.has_key('btn-edit-organisation-redirect'):
            try:
                form = forms.OrganisationForm.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                if REQUEST.get('country_switch', '') == country.adcncodex:
                    form['adorcountry'] = country.adcnname
                    locality_name = REQUEST.get('adorcity', '')
                    try:
                        locality = access_query.get_locality_by_name(session, locality_name)
                        form['adorcity'] = locality.adlocode
                    except:
                        zLOG.LOG(__name__, zLOG.WARNING, '    * Not found locality with name %s"' % locality_name)

                organisation.edit(**form)
                session.merge(organisation)
                #update organisation logo
                if file:
                    organisation.adorlogo = photo_gallery.update_photo(id_photo=organisation.adorlogo,
                                                                       title=form['adorname'],
                                                                       file=REQUEST.form.get('adorlogo', None))
                    session.merge(organisation)
                success = True
        elif REQUEST.form.has_key('btn-delete-organisation-logo'):
            photo_gallery.delete_photo(id=organisation.adorlogo)
            organisation.adorlogo = ''
            session.merge(organisation)
            success = True
        if REQUEST.form.has_key('btn-edit-organisation-redirect'):
            return REQUEST.RESPONSE.redirect('%s/view?id=%s' % (self.absolute_url(), organisation.adorcode))

        default = self.default_coordinates()
        adorhqx = default['longitude']
        adorhqy = default['latitude']
        valid_coord = organisation.adorhqx != None and organisation.adorhqy != None
        if organisation.adorhqx:
            adorhqx = organisation.adorhqx
        if organisation.adorhqy:
            adorhqy = organisation.adorhqy
        zoom = self.default_zoom

        try:
            locality = access_query.get_locality_by_code(session, organisation.adorcity)
            locality_name = locality.name()
        except:
            zLOG.LOG(__name__, zLOG.INFO, '    * Not found locality with id %s"' % organisation.adorcity)
            locality_name = organisation.adorcity

        return self._edit(REQUEST, organisation=organisation, types=types,
                          error=error, success=success,
                          adorhqx=adorhqx, adorhqy=adorhqy,
                          valid_coord = valid_coord,
                          zoom=zoom, city=locality_name,
                          country=country)

    _view = NaayaPageTemplateFile('zpt/directory/organisation_view', globals(), 'ws_organisation_view')
    security.declareProtected(view, 'view')
    def view(self, REQUEST):
        """ view organisation """
        session = self.get_db_session()
        id=REQUEST.get('id', '')
        organisation = organisation_queries.get_organisation(session, id)

        adorhqx = organisation.adorhqx or self.default_longitude
        adorhqy = organisation.adorhqy or self.default_latitude
        zoom = self.default_zoom
        return self._view(REQUEST, organisation=organisation,
                          adorhqx=adorhqx, adorhqy=adorhqy,
                          valid_coord = organisation.adorhqx and organisation.adorhqy,
                          zoom=zoom)

InitializeClass(WSPortalDirectory)
