'''
Created on May 12, 2010

@author: cristiroma
'''
from sqlalchemy.sql.expression import and_
import formencode
from formencode.validators import FormValidator

from ws.common.sql.mappings import Program as program_models


class DuplicateFunding(FormValidator):

    def __init__(self, *args, **kw):
        super(FormValidator, self).__init__(*args, **kw)

    def validate_python(self, field_dict, state):
        session = state
        opfadopcode = field_dict.get('opfadopcode', None)
        adopfcode = field_dict.get('adopfcode', None)
        ob = None
        try:
            ob = session.query(program_models.Budget) \
            .filter(and_(
                    program_models.Budget.opfadopcode==opfadopcode, 
                    program_models.Budget.adopfcode==adopfcode)
            ).one()
        except:
            pass
        if ob:
            message = "Fundings from this organisation already recorded. To modify, remove and add new funding"
            errors = {}
            errors['adopfcode'] = message
            raise formencode.Invalid(message, field_dict, state, error_dict=errors)
