import validators as local_validators
from formencode import Schema, validators

class progressSchema(Schema):
    adopmpopws = validators.Int()
    adopmpopsf = validators.Int()
    adopmpwpnbr = validators.Int()
    adopmwprnbr = validators.Int()
    adopmsfpnbr = validators.Int()
    filter_extra_fields = True
    allow_extra_fields = True
    
class ProgressAddData(progressSchema):
    adopmdate = validators.DateValidator(not_empty=True)

class ProgressEditData(progressSchema):
    pass


class programSchema(Schema):
    filter_extra_fields = True
    allow_extra_fields = True

class Program(programSchema):
    eaadorcode = validators.String(not_empty=True)
    iaadorcode  = validators.String(not_empty=True)
    adopname = validators.String(max=80, not_empty=True)
    adopacron = validators.String(max=20)
    adopdstart = validators.DateValidator()
    adopdend = validators.DateValidator()
    adopctobj = validators.String()
    adopresexp = validators.String()
    adopactiv = validators.String()
    adopbudtot = validators.Int()
    adopurl = validators.String(max=150)

class ProgramDetailsForm(programSchema):
    adopctpre = validators.Bool()
    adopctfea = validators.Bool() 
    adopctcb = validators.Bool() 
    adopctiec = validators.Bool() 
    adopctidev = validators.Bool() 
    adopctass = validators.Bool() 
    adopctme = validators.Bool() 

class ProgramAddFundsForm(programSchema):
    opfadopcode = validators.Number(not_empty=True)
    adopfcode = validators.String(not_empty=True)
    adopfamou = validators.Number(not_empty=True)
    adopfmunit = validators.String(not_empty=True)
    adopfcat = validators.String(not_empty=True)

    chained_validators = [local_validators.DuplicateFunding]

class ProgramTargetValue(programSchema):
    adoptgpop = validators.Int(not_empty=True)
    adoptglocn = validators.Int(not_empty=True)
    adoptgwpn = validators.Int(not_empty=True)
    adoptgrpw = validators.Int(not_empty=True)
    adoptgsfpn = validators.Int(not_empty=True)
