#Python imports
import datetime
from formencode import validators

#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from AccessControl.Permissions import view, view_management_screens
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder, addNyFolder

#Watsan imports
from ws.common.sql.queries import Program as program_queries, Organisation as organisation_queries, Access as access_queries
from ws.common.sql.mappings import Program as program_models
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from Products.WSPortal import constants
from WSPortalProgram import create_wsportalprogram_object_callback
import forms

def create_wsportalprograms_object_callback(parent, id, contributor):
    ob = WSPortalPrograms(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()
    return ob

class WSPortalPrograms(NyFolder):
    """ Programs section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ """
        site = self.getSite()
        portlets_tool = site.getPortletsTool()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]
        portlets_tool.assign_portlet(location, position='left', portlet_id='programs_program', inherit=True)
        portlets_tool.assign_portlet(location, position='left', portlet_id='programs_navigation', inherit=True)


    _listing = NaayaPageTemplateFile('zpt/programs_list', globals(), 'ws_programs_list')
    security.declareProtected(view, 'index_html')
    def index_html(self, REQUEST):
        """ programs list """
        session = self.get_db_session()
        items = program_queries.filter_programs(session,
                                    text=REQUEST.get('q', ''),
                                    locality=REQUEST.get('loc', ''),
                                    subdivision=REQUEST.get('sub', ''),
                                    sort_on=REQUEST.get('sort', 'adopname'),
                                    sort_order=REQUEST.get('order', True))
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        subdiv = None
        if REQUEST.get('sub', ''):
            try:
                subdiv = access_queries.get_subdivision(session, REQUEST.get('sub', ''))
            except:
                pass
        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)
        localities = program_queries.get_program_localities_in_use(session, subdiv)
        subdivisions = program_queries.get_subdivisions_in_use(session)
        return self._listing(REQUEST, programs=items, localities=localities, subdivisions=subdivisions)


    #security.declarePublic('index_html')
    #def get_programs_path(self):
    #    """ returns the programs container path """
    #    return self.absolute_url()

    _map = NaayaPageTemplateFile('zpt/programs_map', globals(), 'ws_programs_map')
    security.declareProtected(view, 'map')
    def map(self, REQUEST):
        """ Map of programs """
        upisx = self.default_longitude
        upisy = self.default_latitude
        zoom = self.default_zoom
        session = self.get_db_session()

        show_ids = REQUEST.get('show')
        show = []
        latest = False
        if show_ids:
            for id in show_ids:
                if id:
                    show.append(program_queries.get_program(session, id))
        if not show:
            # Get the latest three programs from the database
            latest = True
            show = program_queries.latest_programs(session)

        programs = program_queries.list_programs(session, [prog.adopcode for prog in show])

        colors = ['0 0 0', '0 0 255', '255 0 0']
        web_colors = {'1' : '#000000', '2' : '#0000FF', '3' : '#FF0000'}
        overlays = self.getSite().umap.custom.get_programs_map_overlays(show, colors)

        return self._map(REQUEST, upisx=upisx, upisy=upisy, zoom=zoom, programs=programs, show=show, overlays=overlays,
                         web_colors=web_colors, latest=latest)

    security.declareProtected(view, 'listOrganisations')
    def listOrganisations(self):
        """ Returns the organisations list """
        return [ (str(org[0]), org[1]) for org in organisation_queries.get_organisations(self.get_db_session()) ]

    _add_program = NaayaPageTemplateFile('zpt/program/admin/add', globals(), 'ws_program_add')
    security.declareProtected(constants.MANAGE_PROGRAM, 'add')
    def add(self, REQUEST=None):
        """ add a new ongoing program """
        error = None
        session = self.get_db_session()
        form_values = REQUEST.form
        if REQUEST.form.has_key('btn-add-program'):
            try:
                form = forms.Program.to_python(form_values)
            except validators.Invalid, e:
                error = e
            else:
                #add object in database
                program = program_models.Program(**form)
                program.adopdate = datetime.datetime.now()
                program.adopwho = REQUEST.AUTHENTICATED_USER.getUserName()
                session.add(program)
                session.flush()
                #add object in ZODB
                program_id = addNyFolder(self, id=program.adopcode, callback=create_wsportalprogram_object_callback, title=program.adopname)
                ob = self._getOb(program_id)
                return ob._edit_overview(REQUEST, agencies=self.listOrganisations(), error=None, program=program, message_id='added')
        return self._add_program(REQUEST, agencies=self.listOrganisations(), error=error)

    security.declareProtected(view, 'canEditProgram')
    def canEditProgram(self, program, REQUEST):
        """ check if the authenticated user can edit the given program """
        owner = program.getObjectOwner()
        return owner == REQUEST.AUTHENTICATED_USER.getUserName()

    #@todo: delete this update procedure when project is released
    security.declareProtected(view_management_screens, 'update_procedure_add_programs_31032010')
    def update_procedure_add_programs_31032010(self):
        """ """
        items = program_queries.filter_programs(self.get_db_session())
        for item in items:
            if not hasattr(self, str(item.adopcode)):
                addNyFolder(self, id=item.adopcode, callback=create_wsportalprogram_object_callback, title=item.adopname)
        return 'done'

InitializeClass(WSPortalPrograms)
