#Python imports
from GChartWrapper import GChart
from formencode import validators
from copy import copy

#Zope imports
from AccessControl import ClassSecurityInfo, Unauthorized
from Globals import InitializeClass
from AccessControl.Permissions import view

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder, addNyFolder

#Watsan imports
from ws.common.sql.queries import Program as program_queries
from ws.common.sql import query
from ws.common.sql.mappings import Program as program_models
from ws.common.sql.queries import Organisation as organisation_queries
from ws.common.utilities.photo_upload.PhotoUpload import PhotoUpload
from Products.WSPortal import constants
import forms


def create_wsportalprogram_object_callback(parent, id, contributor):
    ob = WSPortalProgram(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.loadDefaultData()
    ob.after_setObject()
    return ob

class WSPortalProgram(NyFolder):
    """ Program folder """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ """
        addNyFolder(self, id='news', title='News', folder_meta_types='Naaya News')
        addNyFolder(self, id='articles', title='Articles', folder_meta_types='Naaya Document')
        addNyFolder(self, id='documents', title='Documents', folder_meta_types='Naaya File')

    security.declarePublic('portlet_navigation')
    portlet_navigation = NaayaPageTemplateFile('zpt/portlets/navigation', globals(), 'ws_programs_portlet_navigation')

    security.declarePublic('get_program_path')
    def get_program_path(self):
        """ returns the program's path """
        return self.absolute_url()

    _index = NaayaPageTemplateFile('zpt/program/index', globals(), 'ws_programs_program_index')
    security.declareProtected(view, 'index_html')
    def index_html(self, REQUEST):
        """ view program """
        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)
        news = self.news.objectValues()
        articles = self.articles.objectValues()
        documents = self.documents.objectValues()
        return self._index(REQUEST, program=program, news=news, articles=articles, documents=documents)

    _details = NaayaPageTemplateFile('zpt/program/details', globals(), 'ws_programs_program_details')
    security.declareProtected(view, 'details')
    def details(self, REQUEST):
        """ program details"""
        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)
        budget = program_queries.get_budget(session, program.adopcode)
        return self._details(REQUEST, program=program, budget=budget)

    _coverage = NaayaPageTemplateFile('zpt/program/coverage', globals(), 'ws_programs_program_map')
    security.declareProtected(view, 'coverage')
    def coverage(self, REQUEST):
        """ program map"""
        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)
        subdivisions = program_queries.get_program_subdivisions(session, program.adopcode)
        localities = program_queries.get_program_localities(session, program.adopcode)
        return self._coverage(REQUEST, program=program, subdivisions=subdivisions, localities=localities)

    _target = NaayaPageTemplateFile('zpt/program/target', globals(), 'ws_programs_program_target')
    security.declareProtected(view, 'target')
    def target(self, REQUEST):
        """ program target"""
        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)
        chart_data = program_queries.get_progress_data(session, program.adopcode)
        return self._target(REQUEST, program = program, progress = chart_data,
                    chart_population_water = self.progress_chart(chart_data, program.adoptgpop, 'adopmpopws'),
                    chart_population_sanitation = self.progress_chart(chart_data, program.adoptglocn, 'adopmpopsf'),
                    chart_new_waterpoints = self.progress_chart(chart_data, program.adoptgwpn, 'adopmpwpnbr'),
                    chart_rehab_waterpoints = self.progress_chart(chart_data, program.adoptgrpw, 'adopmwprnbr'),
                    chart_new_sanitation = self.progress_chart(chart_data, program.adoptgsfpn, 'adopmsfpnbr'),
        )

    _multimedia = NaayaPageTemplateFile('zpt/program/multimedia', globals(), 'ws_programs_program_multimedia')
    security.declareProtected(view, 'multimedia')
    def multimedia(self, REQUEST):
        """ program multimedia area """
        if not self.canEditProgram(self, REQUEST):
            raise Unauthorized

        photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/programs',
                                    album_id=self.id,
                                    album_title=self.title,
                                    context=self)
        session = self.get_db_session()

        program = program_queries.get_program(session, self.id)

        #upload photo
        if REQUEST.form.has_key('btn-submit-photo'):
            title = REQUEST.form.get('title', '')
            file = REQUEST.form.get('file', None)
            kwargs = {}
            #@todo: put some keywordws here
            #kwargs['coverage'] = '%s, %s' % (locality.adloname, locality.subdivision.name)
            #kwargs['keywords'] = 'locality, %s' % locality.adlohgroup_ob.name
            #kwargs['geo_location.lat'] = str(locality.adloy)
            #kwargs['geo_location.lon'] = str(locality.adlox)
            photo_gallery.add_photo(title, file, **kwargs)
        return self._multimedia(REQUEST,
                              program=program,
                              photo_gallery=photo_gallery,
                              errors_photo = photo_gallery.errors)

    ##############################
    #  Administration area       #
    ##############################
    _edit_overview = NaayaPageTemplateFile('zpt/program/admin/edit_overview', globals(), 'ws_programs_program_edit_overview')
    security.declareProtected(constants.MANAGE_PROGRAM, 'edit_overview')
    def edit_overview(self, REQUEST):
        """ Edit overview of the program """
        if not self.canEditProgram(self, REQUEST):
            raise Unauthorized

        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)

        error = None
        message_id = None
        if REQUEST.form.has_key('btn-edit-program'):
            try:
                form = forms.Program.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                #@todo: improve edit program
                form_program = program_models.Program(**form)
                program.adopname = form_program.adopname
                program.adopacron = form_program.adopacron
                program.adopdstart = form_program.adopdstart
                program.adopdend = form_program.adopdend
                program.adopbudtot = form_program.adopbudtot
                program.adopurl = form_program.adopurl
                program.adopctobj = form_program.adopctobj
                program.adopresexp = form_program.adopresexp
                program.adopactiv = form_program.adopactiv
                program.eaadorcode = form_program.eaadorcode
                program.iaadorcode = form_program.iaadorcode
                session.merge(program)
                session.flush()
                message_id = 'updated'
        return self._edit_overview(REQUEST, agencies=self.listOrganisations(), error=error, program=program, message_id=message_id)

    _edit_details = NaayaPageTemplateFile('zpt/program/admin/edit_details', globals(), 'ws_programs_program_edit_details')
    security.declareProtected(constants.MANAGE_PROGRAM, 'edit_details')
    def edit_details(self, REQUEST):
        """ Edit details of the program """
        if not self.canEditProgram(self, REQUEST):
            raise Unauthorized

        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)
        error = None
        message_id = None
        if REQUEST.form.has_key('btn-edit-details'):
            try:
                form = forms.ProgramDetailsForm.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                form_program = program_models.Program(**form)
                program.adopctpre = form_program.adopctpre
                program.adopctfea = form_program.adopctfea
                program.adopctcb = form_program.adopctcb
                program.adopctiec = form_program.adopctiec
                program.adopctidev = form_program.adopctidev
                program.adopctass = form_program.adopctass
                program.adopctme = form_program.adopctme
                session.merge(program)
                session.flush()
                message_id = 'updated'
        if REQUEST.form.has_key('btn-add-budget'):
            try:
                form = forms.ProgramAddFundsForm.to_python(REQUEST.form, state=session)
            except validators.Invalid, e:
                error = e
            else:
                ob = program_models.Budget(**form)
                session.add(ob)
                session.flush()
                message_id = 'updated'
        if REQUEST.form.has_key('btn-delete-budget'):
            program_code = REQUEST.get('opfadopcode')
            organisation_code = REQUEST.get('adopfcode')
            program_queries.remove_budget(session, program_code, organisation_code)
            message_id = 'updated'
        budget = program_queries.get_budget(session, program.adopcode)
        lex_opb005 = query.get_lexicon_objects(session, query.get_lexicon_klass('LexOpb005'))
        return self._edit_details(REQUEST, agencies=self.listOrganisations(),
                    error=error, program=program, budget=budget,
                    message_id=message_id, lex_opb005=lex_opb005)

    _edit_target = NaayaPageTemplateFile('zpt/program/admin/edit_target', globals(), 'ws_programs_program_edit_target')
    security.declareProtected(constants.MANAGE_PROGRAM, 'edit_target')
    def edit_target(self, REQUEST):
        """ edit program chart details """
        if not self.canEditProgram(self, REQUEST):
            raise Unauthorized

        session = self.get_db_session()
        error = None
        selected = None
        success = False

        program = program_queries.get_program(session, self.id)

        if REQUEST.form.has_key('btn-add-value'):
            try:
                form = forms.ProgressAddData.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                progress = program_models.ProgressData(opmadopcode=program.adopcode, **form)
                session.add(progress)
                success = True

        elif REQUEST.form.has_key('btn-edit-target'):
            try:
                form = forms.ProgramTargetValue.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                program.edit(**form)
                session.merge(program)
                success = True

        elif REQUEST.form.has_key('btn-delete-values'):
            dates = REQUEST.form.get('dates', '')
            for data in program_queries.get_progress_data(session, program.adopcode):
                if str(data.adopmdate) in self.utConvertToList(dates):
                    session.delete(data)
            success = True

        elif REQUEST.form.has_key('btn-edit-value'):
            try:
                form = forms.ProgressEditData.to_python(REQUEST.form)
            except validators.Invalid, e:
                error = e
            else:
                selected = program_queries.get_progress_data(session, program.adopcode, date=REQUEST.form.get('adopmdate'))
                selected.edit(**form)
                session.merge(selected)
                success = True

        if REQUEST.has_key('adopmdate'):
            selected = program_queries.get_progress_data(session, program.adopcode, date=REQUEST.get('adopmdate'))

        program_data = program_queries.get_progress_data(session, program.adopcode)
        return self._edit_target(REQUEST, program=program, data=program_data, selected=selected, error=error, success=success)

    _edit_coverage = NaayaPageTemplateFile('zpt/program/admin/edit_coverage', globals(), 'ws_programs_program_edit_coverage')
    security.declareProtected(constants.MANAGE_PROGRAM, 'edit_coverage')
    def edit_coverage(self, REQUEST):
        """ Coverage """
        if not self.canEditProgram(self, REQUEST):
            raise Unauthorized

        session = self.get_db_session()
        program = program_queries.get_program(session, self.id)
        message_id = None
        form_errors = None
        error = {'error_dict' : {}, 'value' : {}}
        if REQUEST.form.has_key('btn-add-subdivision'):
            subdivision_code = REQUEST.get('subdivision', None)
            if program_queries.validate_add_subdivision(session, program.adopcode, subdivision_code):
                program_queries.add_subdivision(session, program.adopcode, subdivision_code)
                message_id = 'updated'
            else:
                error['error_dict']['add_subdivision'] = True
                error['value']['subdivision'] = subdivision_code

        elif REQUEST.form.has_key('btn-delete-subdivision'):
            subdivision_code = REQUEST.get('subdivision', None)
            if program_queries.validate_delete_subdivision(session, program.adopcode, subdivision_code):
                program_queries.delete_subdivision(session, program.adopcode, subdivision_code)
                message_id = 'updated'
            else:
                error['error_dict']['delete_subdivision'] = True
                error['value']['subdivision'] = subdivision_code

        elif REQUEST.form.has_key('btn-add-locality'):
            locality_code = REQUEST.get('locality', None)
            if program_queries.validate_add_locality(session, program.adopcode, locality_code):
                program_queries.add_locality(session, program.adopcode, locality_code)
                message_id = 'updated'
            else:
                error['error_dict']['add_locality'] = True
                error['value']['locality'] = locality_code

        elif REQUEST.form.has_key('btn-delete-locality'):
            locality_code = REQUEST.get('locality', None)
            if program_queries.validate_delete_locality(session, program.adopcode, locality_code):
                program_queries.delete_locality(session, program.adopcode, locality_code)
                message_id = 'updated'
            else:
                error['error_dict']['delete_locality'] = True
                error['value']['locality'] = locality_code


        subdivisions = program_queries.get_program_subdivisions(session, program.adopcode)
        localities = program_queries.get_program_localities(session, program.adopcode)
        subdivision_list = program_queries.get_subdivision_list(session, [subdiv.code for subdiv in subdivisions])
        localities_list = program_queries.get_localities_list(session,
                                [subdiv.code for subdiv in subdivisions],
                                [loc.adlocode for loc in localities])

        return self._edit_coverage(REQUEST, program=program, subdivisions=subdivisions,
                    localities=localities, subdivision_list=subdivision_list,
                    localities_list=localities_list, message_id=message_id, form_errors=form_errors, error=error)


    security.declareProtected(constants.MANAGE_PROGRAM, 'template_program_edit')
    template_program_edit = NaayaPageTemplateFile('zpt/program/admin/template_edit', globals(), 'ws_programs_program_template_edit')

    security.declareProtected(view, 'template_program_index')
    template_program_index = NaayaPageTemplateFile('zpt/program/template_index', globals(), 'ws_programs_program_template_index')

    ##############################
    #  Progress charts           #
    ##############################

    security.declarePrivate('scale_value')
    def scale_value(self, value, max):
        scaled_value = value*100/max
        if scaled_value == 100:
            scaled_value = 99.9
        return scaled_value

    security.declarePrivate('progress_chart')
    def progress_chart(self, chart_data, max, filter='adopmpopws'):
        """ population served with water """

        if chart_data:
            args = []
            values = []

            CHART_WIDTH = 400
            CHART_HEIGHT = 200

            for data in chart_data:
                args.append(data.adopmdate_year())
                values.append(getattr(data, filter))

            values_copy = copy(values)
            values_copy.sort()
            max_chart_value = values_copy[-1]
            if max_chart_value > max:
                max = max_chart_value

            achieved = [self.scale_value(v, max) for v in values if v is not None]
            objective = [100]*len(achieved)

            bar_holder = CHART_WIDTH/len(achieved)
            barw = bar_holder*4/6
            if barw > 70:
                barw = 70
            bars = bar_holder*1/6

            chart = GChart(ctype='bvo', dataset=[objective, achieved], encoding='text')
            chart.color('dbe5fa', '4D89F9')
            chart.size(CHART_WIDTH, CHART_HEIGHT)
            chart.bar(barw, bars)
            chart.legend('Objective', 'Achieved')
            chart.legend_pos('b')
            chart.axes('xy')
            chart.axes.label(0, *args)
            chart.axes.label(1, 0, str(max/2), str(max))
            return chart.url

    security.declarePrivate('listOrganisations')
    def listOrganisations(self):
        """ Returns the list of organisations """
        return [ (str(org[0]), org[1]) for org in organisation_queries.get_organisations(self.get_db_session()) ]


InitializeClass(WSPortalProgram)
