from sqlalchemy.schema import Table, MetaData, Column
from sqlalchemy.types import String, Integer, Text, Date, Boolean
from sqlalchemy.orm import mapper, relation


metadata = MetaData()
actu = Table('actu', metadata,
        Column('id_actu', Integer, primary_key=True),
        Column('red_actu', String),
        Column('titre_actu_fr', Text),
        Column('titre_actu_en', Text),
        Column('desc_actu_fr', Text),
        Column('desc_actu_en', Text),
        Column('txt_actu_fr', Text),
        Column('txt_actu_en', Text),
        Column('source_actu', Text),
        Column('obs_actu', Text),
        Column('date_actu', Date),
        Column('photo', String),
        Column('maj_actu', Date),
        Column('verif_actu', Date),
        Column('modif_by', String),
        Column('non_publier', Integer),
        Column('publier', Integer),
        Column('type_actu', Integer),
        Column('theme', Integer),
)

class Actu(object):
    """ Mapping for Actu table (actu) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(Actu, actu)

metadata = MetaData()
docs = Table('docs', metadata,
        Column('id', Integer, primary_key=True),
        Column('titre_fr', String),
        Column('titre_en', String),
        Column('descr_fr', Text),
        Column('descr_en', Text),
        Column('resume_fr', Text),
        Column('resume_en', Text),
        Column('photo_fr', String),
        Column('photo_en', String),
        Column('fichier_fr', String),
        Column('fichier_en', String),
        Column('type_fr', String),
        Column('type_en', String),
        Column('poids_fr', Integer),
        Column('poids_en', Integer),
        Column('url_fr', String),
        Column('url_en', String),
        Column('date_pub', Date),
        Column('maj', Date),
        Column('verif', Date),
        Column('obs_priv', String),
        Column('redacteur', String),
        Column('modif_by', String),
        Column('non_publier', Integer),
        Column('publier', Integer),

)
class Docs(object):
    """ Mapping for Docs table (docs) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(Docs, docs)