from formencode import validators
from AccessControl.SecurityInfo import ClassSecurityInfo
from AccessControl.Permissions import view, view_management_screens
from Globals import InitializeClass

from Products.Naaya.NyFolder import NyFolder
from naaya.content.news.news_item import addNyNews
from naaya.content.document.document_item import addNyDocument
import models


def create_senegal_object_callback(parent, id, contributor):
    ob = Senegal(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

class Senegal(NyFolder):
    """ Senegal import data """

    security = ClassSecurityInfo()

    security.declareProtected(view_management_screens, 'import_news')
    def import_news(self, REQUEST=None):
        """ """
        session = self.get_db_session()
        site = self.getSite()
        news_folder = site.news_articles._getOb('news')
        news_list =  session.query(models.Actu).all()
        for news in news_list:
            if news.publier:
                approved = 1
            if news.non_publier:
                approved = 0

            try:
                id = addNyNews(news_folder,
                          title = news.titre_actu_en,
                          description = news.desc_actu_en,
                          details = news.txt_actu_en,
                          source = news.source_actu,
                          releasedate = news.date_actu,
                          lang = 'en',
                          submitted= True)
                ob = news_folder._getOb(id)
                ob.approveThis(approved, approved_by=REQUEST.AUTHENTICATED_USER.getUserName())
                ob.manageProperties(title = news.titre_actu_fr,
                                    description = news.desc_actu_fr,
                                    details = news.txt_actu_fr,
                                    lang = 'fr')
            except ValueError:
                try:
                    id = addNyNews(news_folder,
                              title = news.titre_actu_fr,
                              description = news.desc_actu_fr,
                              details = news.txt_actu_fr,
                              source = news.source_actu,
                              releasedate = news.date_actu,
                              lang = 'fr',
                              submitted= True)
                    ob = news_folder._getOb(id)
                    ob.approveThis(approved, approved_by=REQUEST.AUTHENTICATED_USER.getUserName())
                    if news.titre_actu_en:
                        ob.manageProperties(title = news.titre_actu_en,
                                            description = news.desc_actu_en,
                                            details = news.txt_actu_en,
                                            lang = 'en')
                except ValueError:
                    pass
        return 'done'

    security.declareProtected(view_management_screens, 'import_docs')
    def import_docs(self, REQUEST=None):
        """ """
        session = self.get_db_session()
        site = self.getSite()
        docs_folder = site.news_articles._getOb('documents')
        docs_list =  session.query(models.Docs).all()
        for doc in docs_list:
            if doc.publier:
                approved = 1
            else:
                approved = 0
            try:
                id = addNyDocument(docs_folder,
                          title = doc.titre_en,
                          description = doc.resume_en,
                          body = doc.descr_en,
                          resourceurl = doc.url_en,
                          releasedate = doc.date_pub,
                          lang = 'en',
                          submitted= True)
                ob = docs_folder._getOb(id)
                ob.approveThis(approved, approved_by=REQUEST.AUTHENTICATED_USER.getUserName())
                ob.manageProperties(title = doc.titre_fr,
                                    description = doc.resume_fr,
                                    body = doc.descr_fr,
                                    resourceurl = doc.url_fr,
                                    lang = 'fr',
                                    approved = approved)
            except ValueError:
                try:
                    id = addNyDocument(docs_folder,
                              title = doc.titre_fr,
                              description = doc.resume_fr,
                              body = doc.descr_fr,
                              resourceurl = doc.url_fr,
                              releasedate = doc.date_actu,
                              lang = 'fr',
                              submitted = True)
                    ob = docs_folder._getOb(id)
                    ob.approveThis(approved, approved_by=REQUEST.AUTHENTICATED_USER.getUserName())
                    if doc.titre_actu_en:
                        ob.manageProperties(title = doc.titre_en,
                                            description = doc.resume_en,
                                            body = doc.descr_en,
                                            resourceurl = doc.url_en,
                                            lang = 'en',
                                            approved = approved)
                except ValueError:
                    print doc.id
        return 'done'

InitializeClass(Senegal)