""" IWRM portal section """

#Zope imports
from OFS import Folder
import zLOG

#Product imports
from Products.WSPortal.IWRM import IWRMProduct

def initialize(context):
    """
        Product initialization method
        @param context: Zope server context
    """
    try:
        context.registerClass(
                IWRMProduct.IWRM,
                constructors = (
                    Folder.manage_addFolderForm,
                    Folder.manage_addFolder),
                )
    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        zLOG.LOG(__name__, zLOG.ERROR, 'An error occurred during product initialization. No WatSan country portal "IWRM" section available', error = (type, val, tb), reraise=True)
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb

