from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

from ws.common.sql.queries import WaterQuality as query
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage

def create_waterquality_object_callback(parent, id, contributor):
    ob = WaterQuality(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()
    return ob

class WaterQuality(NyFolder):
    """ WaterQuality (located in IWRM section of the portal) """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ Load the initial data """
        # Add left portlets @todo: to be defined
        site = self.getSite()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]
        #
        #portlets_tool = site.getPortletsTool()
        #portlets_tool.assign_portlet(location, position='left', portlet_id='facilities_navigation', inherit=True)

    security.declarePublic('index_html')
    def index_html(self, REQUEST):
        """ Index page for WaterQuality section """
        session = self.get_db_session()
        report_values = []
        report = None
        
        #conformity = REQUEST.get('conf', 1)
        #try:
        #    conformity = int(conformity)
        #except ValueError:
        #    conformity = 0
        items = query.filter_water_reports(session,
                                    #conformity = conformity,
                                    sort_on = REQUEST.get('sort', 'wqmdate'),
                                    sort_order = REQUEST.get('order', False))
        paginator = DiggPaginator(items, 10, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)

        #get water quality measurements attached to a given report id
        id = REQUEST.get('id', '')
        if id:
            try:
                report = query.get_wqm(session, id)
                report_values = query.get_wqm_data(session, id)
            except:
                pass

        return self._index_html(REQUEST,
                                reports = items,
                                report = report,
                                report_values = report_values)

    _index_html = NaayaPageTemplateFile('zpt/waterquality/index', globals(), 'iwrm_waterquality_index')

InitializeClass(WaterQuality)