

from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

from ws.common.sql.queries import IWRM as iwrm_queries
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from ws.common.sql.queries.Access import get_subdivision_upis


def create_uws_object_callback(parent, id, contributor):
    ob = UWS(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()
    return ob


class UWS(NyFolder):
    """ "Waterpoints" section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ Load the initial data """
        # Add left portlets
        site = self.getSite()
        portlets_tool = site.getPortletsTool()


    _list_html = NaayaPageTemplateFile('zpt/uws/list', globals(), 'ws_iwrm_uws_list')
    def list(self, REQUEST):
        """ Page with list of underground water sources """
        items = iwrm_queries.list_uws(self.get_db_session(),
                                    text=REQUEST.get('q', ''),
                                    locality=REQUEST.get('loc', ''),
                                    sort_on=REQUEST.get('sort', 'adloname'),
                                    sort_order=REQUEST.get('order', True))
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)


        return self._list_html(REQUEST, list_uws=items)
    index_html = list


    _view_html = NaayaPageTemplateFile('zpt/uws/view', globals(), 'ws_iwrm_uws_view')
    def view(self, id, REQUEST):
        """ Page with list of underground water sources """
        session = self.get_db_session()
        item = iwrm_queries.get_uws(session, id)
        subdivision = get_subdivision_upis(session, item)
        return self._view_html(REQUEST, item=item, subdivision=subdivision)

InitializeClass(UWS)