#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

#Naaya imports
from Products.Naaya.NyFolder import NyFolder, addNyFolder
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from ws.common.sql.queries import IWRM as iwrm_queries

from Products.WSPortal.IWRM.UWS import create_uws_object_callback
from Products.WSPortal.IWRM.WaterQuality import create_waterquality_object_callback
from ws.common.sql.queries.Access import get_subdivision_upis

def create_iwrm_object_callback(parent, id, contributor):
    ob = IWRM(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()
    return ob


class IWRM(NyFolder):
    """ "IWRM" section of the portal """
    security = ClassSecurityInfo()
    security.declarePrivate('loadDefaultData')

    def loadDefaultData(self, *args, **kwargs):
        """ Load the initial data """
        # Add left portlets
        site = self.getSite()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]

        portlets_tool = site.getPortletsTool()
        portlets_tool.assign_portlet(location, position='left', portlet_id='iwrm_navigation', inherit=True)

        addNyFolder(self, id='water_quality', callback=create_waterquality_object_callback, title='Water quality monitoring', folder_meta_types =['Naaya Folder'])
        addNyFolder(self, id='uws', callback=create_uws_object_callback, title='Undeground water sources', folder_meta_types =['Naaya Folder'])

    _index_html = NaayaPageTemplateFile('zpt/index', globals(), 'ws_iwrm_index')
    def index_html(self, REQUEST):
        """ Index page for IWRM section """
        session = self.get_db_session()
        count_uws = iwrm_queries.count_uws(session)
        count_mostations = iwrm_queries.count_monitoring_stations(session)
        count_basins = iwrm_queries.count_basins(session)
        count_aquifers = iwrm_queries.count_aquifers(session)
        count_rivers = iwrm_queries.count_rivers(session)

        upisx = REQUEST.get('upisx', self.default_longitude)
        upisy = REQUEST.get('upisy', self.default_latitude)
        zoom = REQUEST.get('zoom', self.default_zoom)

        return self._index_html(REQUEST, count_uws = count_uws, 
                                count_mostations = count_mostations,
                                count_basins = count_basins,
                                count_aquifers = count_aquifers,
                                count_rivers = count_rivers, 
                                upisx = upisx, upisy = upisy, zoom = zoom)


    _view_mostation_html = NaayaPageTemplateFile('zpt/mostation', globals(), 'ws_iwrm_mostation')
    def view_mostation(self, id, REQUEST):
        """ Index page for IWRM section """
        ob = iwrm_queries.get_mostation(self.get_db_session(), id)
        return self._view_mostation_html(REQUEST, ob = ob)


    _balloon_mostation_html = NaayaPageTemplateFile('zpt/balloons/mostation', globals(), 'ws_iwrm_balloon_mostation')
    def balloon_mostation(self, id, REQUEST):
        """ Balloon html template page for monitoring station.
        """
        ob = iwrm_queries.get_mostation(self.get_db_session(), id)
        return self._balloon_mostation_html(REQUEST, ob = ob)


    _balloon_uws_html = NaayaPageTemplateFile('zpt/balloons/uws', globals(), 'ws_iwrm_balloon_uws')
    def balloon_uws(self, id, REQUEST):
        """ Balloon html template page for undeground water source.
        """
        session = self.get_db_session()
        ob = iwrm_queries.get_uws(session, id)
        subdivision = get_subdivision_upis(session, ob)
        return self._balloon_uws_html(REQUEST, ob = ob, subdivision = subdivision)

    _balloon_basin_html = NaayaPageTemplateFile('zpt/balloons/basin', globals(), 'ws_iwrm_balloon_basin')
    def balloon_basin(self, id, REQUEST):
        """ Balloon html template page for basin.
        """
        ob = iwrm_queries.get_basin(self.get_db_session(), id)
        return self._balloon_basin_html(REQUEST, ob = ob)


    _balloon_aquifer_html = NaayaPageTemplateFile('zpt/balloons/aquifer', globals(), 'ws_iwrm_balloon_aquifer')
    def balloon_aquifer(self, id, REQUEST):
        """ Balloon html template page for aquifer.
        """
        ob = iwrm_queries.get_aquifer(self.get_db_session(), id)
        return self._balloon_aquifer_html(REQUEST, ob = ob)


    _balloon_river_html = NaayaPageTemplateFile('zpt/balloons/river', globals(), 'ws_iwrm_balloon_river')
    def balloon_river(self, id, REQUEST):
        """ Balloon html template page for river.
        """
        ob = iwrm_queries.get_river(self.get_db_session(), id)
        return self._balloon_river_html(REQUEST, ob = ob)

InitializeClass(IWRM)