'''
Created on May 18, 2010

@author: cristiroma
'''
from formencode.validators import FormValidator
from formencode import Schema, validators, Invalid
from ws.common import validation

class FacilitiesForm(Schema):
    filter_extra_fields = False
    allow_extra_fields = True


class AddSanitationFacilityForm(FacilitiesForm):

    upisx = validators.Number(not_empty=True)
    upisy = validators.Number(not_empty=True)
    upisloctype = validation.UpisloctypeValidator()
    upisobj = validation.WP051Validator()


class AddWaterPointForm(FacilitiesForm):

    upisx = validators.Number(not_empty=True)
    upisy = validators.Number(not_empty=True)
    upisloctype = validation.UpisloctypeValidator()
    upwpmainuse = validation.WP009Validator()
    upisobj = validation.WP051Validator()


class RequireIfMissing(FormValidator):
    """  """

    required = None
    missing = None
    present = None
    __unpackargs__ = ('required',)

    def _to_python(self, value_dict, state):
        is_required = False
        if self.missing and not value_dict.get(self.missing):
            is_required = True
        if self.present and value_dict.get(self.present):
            is_required = True
        if is_required and not value_dict.get(self.required):
            raise Invalid('You must give a value for %s' % self.required,
                          value_dict, state,
                          error_dict={self.required: Invalid(self.message(
                              'empty', state), value_dict, state)})
        return value_dict

RequireIfPresent = RequireIfMissing

class NonFunctioningForm(Schema):
    """ """
    user = validators.String()
    user_name = validators.String(if_missing=None)
    user_email = validators.Email(if_missing=None)
    user_comment = validators.String(not_empty=True)
    filter_extra_fields = True
    allow_extra_fields = True
    chained_validators = [RequireIfMissing('user_name', missing='user'),
                          RequireIfMissing('user_email', missing='user')]

