""" Facilities portal section """

#Zope imports
from OFS import Folder
import zLOG

#Product imports
from Products.WSPortal.Facilities import WSPortalFacilities

def initialize(context):
    """
        Product initialization method
        @param context: Zope server context
    """
    try:
        context.registerClass(
                WSPortalFacilities.WSPortalFacilities,
                constructors = (
                    Folder.manage_addFolderForm,
                    Folder.manage_addFolder),
                )
    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        zLOG.LOG(__name__, zLOG.ERROR, 'An error occurred during product initialization. No WatSan country portal "Facilities" section available', error = (type, val, tb), reraise=True)
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb

