from datetime import datetime

#Zope imports
from formencode import validators
from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

#Watsan imports
import forms
from ws.common.sql.mappings import Lexicon
from ws.common import validation
from ws.common.sql import update
from ws.common.sql import query
from ws.common.sql.queries import Access as access_queries
from ws.common.sql.queries import Facilities as facilities_queries
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from ws.common.utilities.photo_upload.PhotoUpload import PhotoUpload

from Products.WSPortal import constants
from Products.WSPortal.Comments.models import UpisComment
from Products.WSPortal.Comments.Comments import Comment


def create_waterpoints_object_callback(parent, id, contributor):
    ob = Waterpoints(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()
    return ob

class Waterpoints(NyFolder):
    """ "Waterpoints" section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ Load the initial data """
        # Add left portlets
        site = self.getSite()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]

        portlets_tool = site.getPortletsTool()
        portlets_tool.assign_portlet(location, position='left', portlet_id='facilities_search', inherit=True)
        portlets_tool.assign_portlet(location, position='left', portlet_id='waterpoints_navigation', inherit=True)

    security.declarePublic('list_waterpoints_localities')
    def list_waterpoints_localities(self):
        """ Retrieve the list of water points localities """
        localities = query.get_waterpoints_localities(self.get_db_session())
        return [(loc[0], loc[1]) for loc in localities if loc and loc[0] and loc[1]]

    security.declarePublic('list_waterpoints_functionalities')
    def list_waterpoints_functionalities(self):
        """ Retrieve the list of water points functionalities """
        functionalities = query.get_waterpoints_functionalities(self.get_db_session())
        return [(fun[0], fun[1]) for fun in functionalities if fun and fun[0] and fun[1]]

    security.declarePublic('index_html')
    def index_html(self, REQUEST):
        """ Water points listing """
        items = query.filter_water_points(self.get_db_session(),
                                    text = REQUEST.get('q', ''),
                                    id_subdivision = REQUEST.get('id_subdivision', ''),
                                    id_locality = REQUEST.get('id_locality', ''),
                                    functionality = REQUEST.get('func', ''),
                                    sort_on = REQUEST.get('sort', 'adloname'),
                                    sort_order = REQUEST.get('order', True))
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)

        return self._list(REQUEST, waterpoints=items,
                        localities=self.list_waterpoints_localities(),
                        functionalities=self.list_waterpoints_functionalities())

    security.declareProtected(constants.REPORT_NON_INVENTORIED, 'add')
    def add(self, REQUEST):
        """
        Suggest non-inventoried water point.
        """
        session = self.get_db_session()
        error = subdivision = locality = None
        subdivisions = localities = parents = []
        repost = REQUEST.get('repost', False)
        level = 1

        default_coord = self.default_coordinates()
        map_centerx = default_coord['x']
        map_centery = default_coord['y']

        upisx = REQUEST.get('upisx', None)
        upisy = REQUEST.get('upisy', None)
        if upisx and upisy:
            map_centerx = upisx
            map_centery = upisy
        zoom = REQUEST.get('zoom', self.default_zoom)

        id_subdivision = REQUEST.get('subdivision', None)
        id_locality = REQUEST.get('adlocode', None)
        if id_subdivision:
            subdivision = access_queries.get_subdivision(session, REQUEST.get('subdivision'))
            parents = access_queries.get_subdivision_parents(session, subdivision)
            parents.append(subdivision)
            level = subdivision.level
            if subdivision.level == access_queries.get_subdivision_max(session):
                localities = access_queries.get_localities(session, subdivision).all() #SQLAlchemy Query
            else:
                level += 1
                subdivisions = access_queries.get_subdivision_list(session, subdivision.code)
        else:
            subdivisions = access_queries.get_subdivision_list(session, id_subdivision)

        if id_locality:
            locality = access_queries.get_locality_by_code(session, id_locality)

        if REQUEST.form.has_key('btn-select-locality'):
            map_centerx = upisx = locality.adlox
            map_centery = upisy = locality.adloy
            zoom = self.default_zoom

        if REQUEST.form.has_key('btn-add-facility'):

            try:
                form = forms.AddWaterPointForm.to_python(REQUEST.form, state=session)
            except validators.Invalid, e:
                error = e
            else:
                # Save in database
                form['upisupdate'] = datetime.now()
                form['upisupwho'] = REQUEST.AUTHENTICATED_USER.getUserName()
                upis, facility = facilities_queries.insert_new_waterpoint(session, form)
                #coverage = locality.adloname + ', ' + subdivision.name
                #keywords = ', '.join(['Sanitation facility'])
                #geo_kwargs = {'geo_location.lat': '%s' % upis.upisy, 'geo_location.lon': '%s' % upis.upisx}

                photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/waterpoints', context=self,
                                            album_id=upis.upiscode, album_title='')

                # Save in pictures in ZoDB
                for k in REQUEST.form.keys():
                    if k.startswith('file'):
                        #keywords = ['waterpoint']
                        #@todo: save main_use, wp_type, etc
                        kwargs = {}
                        if locality:
                            kwargs['coverage'] = '%s, %s' % (locality.adloname, locality.subdivision.name)
                        kwargs['geo_location.lat'] = str(upis.upisy)
                        kwargs['geo_location.lon'] = str(upis.upisx)
                        photo_gallery.add_photo('', REQUEST.form[k], **kwargs)

                return REQUEST.RESPONSE.redirect(self.finish.absolute_url())
        return self._add(REQUEST, upisx = upisx, upisy=upisy, zoom=zoom,
            id_subdivision = id_subdivision, id_locality = id_locality,
            subdivisions = subdivisions, localities = localities, level = level,
            parents = parents, error = error, repost=repost,
            map_centerx = map_centerx, map_centery = map_centery)

    security.declareProtected(constants.EDIT_DATA, 'approve')
    def approve(self, REQUEST):
        """ approve waterpoint """
        session = self.get_db_session()
        id = REQUEST.get('id', '')
        errors = []

        photo_gallery = PhotoUpload(gallery = 'resources/multimedia/photos/waterpoints', context=self,
                                    album_id = id, album_title = '')

        if REQUEST.form.has_key('delete'):
            update.delete_waterpoint(session, id)
            photo_gallery.delete_album()
            return REQUEST.RESPONSE.redirect('%s/pending?del=ok' % self.absolute_url())

        elif REQUEST.form.has_key('approve'):
            errors = validation.validate_waterpoint_approval(session, REQUEST.form)
            if not errors:
                upisx = REQUEST.form['upisx']
                upisy = REQUEST.form['upisy']
                # Update database data
                update.approve_facility(session, id, upisx, upisy)
                return REQUEST.RESPONSE.redirect('%s/pending?app=ok' % self.absolute_url())

        elif REQUEST.form.has_key('delete-photos'):
            for photo in self.utConvertToList(REQUEST.form.get('ids', [])):
                photo_gallery.delete_photo(photo)

        waterpoint = query.get_pending_water_point_by_id(self.get_db_session(), id)
        locality = access_queries.get_locality_by_code(session, waterpoint.adlocode)
        upisloctype = query.get_lexicon_row(session, Lexicon.LexUpisloctype, waterpoint.upisloctype)
        upwpmainuse = query.get_lexicon_row(session, Lexicon.LexWP009, waterpoint.upwpmainuse)
        upisobj = query.get_lexicon_row(session, Lexicon.LexWP051, waterpoint.upisobj)

        upisx = waterpoint.upisx
        upisy = waterpoint.upisy
        zoom = self.default_zoom

        return self._approve(REQUEST, locality=locality, waterpoint=waterpoint,
                                        upisobj=upisobj, upwpmainuse=upwpmainuse,
                                        upisloctype=upisloctype,
                                        upisx=upisx, upisy=upisy,
                                        zoom=zoom, errors=errors, photo_gallery=photo_gallery)

    security.declarePublic('map')
    def map(self, REQUEST):
        """ Display the map with water points """
        upisx = REQUEST.get('upisx', self.default_longitude)
        upisy = REQUEST.get('upisy', self.default_latitude)
        zoom = REQUEST.get('zoom', self.default_zoom)
        return self._map(REQUEST, upisx=upisx, upisy=upisy, zoom=zoom,
                                     localities=self.list_waterpoints_localities(),
                                     functionalities=self.list_waterpoints_functionalities())

    security.declarePublic('view')
    def view(self, REQUEST):
        """ water point index """
        id = REQUEST.get('id', '')
        session = self.get_db_session()
        report_errors = report_success = None

        private = False
        if REQUEST.get('details', '') and not self.isAnonymousUser():
            private = True

        waterpoint = access_queries.get_waterpoint(session, id)

        comments_tool = Comment(model = UpisComment, code = waterpoint.upiscode,
                                session = session, context = self)

        photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/waterpoints', context=self,
                                    album_id=waterpoint.upiscode, album_title='')

        #report non-functioning waterpoint
        if REQUEST.form.has_key('btn-report-waterpoint'):
            report_errors, report_success = self.report_non_functioning(code = waterpoint.upiscode,
                                                                        template = 'report_sanitation',
                                                                        REQUEST = REQUEST)

        #upload photo
        if REQUEST.form.has_key('btn-submit-photo') and self.checkPermissionPostPhoto():
            title = id
            file = REQUEST.form.get('file', None)
            kwargs = {}
            kwargs['coverage'] = '%s, %s' % (waterpoint.locality.adloname, waterpoint.locality.subdivision.name)

            keywords = ['waterpoint']
            if waterpoint.upwpmainuse_ob:
                keywords.append(waterpoint.upwpmainuse_ob.name)
            if waterpoint.wptype:
                keywords.append(waterpoint.wptype.name)
            if waterpoint.upisobj_name:
                keywords.append(waterpoint.upisobj_name)

            kwargs['keywords'] = ', '.join(keywords)
            kwargs['geo_location.lat'] = str(waterpoint.upisy)
            kwargs['geo_location.lon'] = str(waterpoint.upisx)
            photo_gallery.add_photo(title, file, **kwargs)

        #add comment
        if REQUEST.form.has_key('btn-add-comment'):
            comments_tool.add_comment(REQUEST)

        return self._view(REQUEST,
                            waterpoint = waterpoint,
                            photo_gallery = photo_gallery,
                            errors_photo = photo_gallery.errors,
                            comments_tool = comments_tool,
                            errors = comments_tool.errors,
                            report_success = report_success,
                            report_errors = report_errors,
                            private = private)

    _view = NaayaPageTemplateFile('zpt/waterpoints/view', globals(), 'ws_facilities_waterpoint')
    _list = NaayaPageTemplateFile('zpt/waterpoints/list', globals(), 'ws_facilities_list_waterpoints')
    _map = NaayaPageTemplateFile('zpt/waterpoints/map', globals(), 'ws_facilities_map_waterpoint')
    _add = NaayaPageTemplateFile('zpt/waterpoints/add', globals(), 'ws_facilities_add_waterpoint')
    _approve = NaayaPageTemplateFile('zpt/waterpoints/approve', globals(), 'ws_facilities_approve_waterpoint')    
    
InitializeClass(Waterpoints)
