
from datetime import datetime

#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass
from formencode import validators

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

#Watsan imports
import forms
from ws.common.sql import query
from ws.common.sql.mappings import Lexicon
from ws.common import validation
from ws.common.sql import update
from ws.common.sql.queries import Access as access_queries
from ws.common.sql.queries import Facilities as facilities_queries
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from ws.common.utilities.photo_upload.PhotoUpload import PhotoUpload

from Products.WSPortal import constants
from Products.WSPortal.Comments.models import UpisComment
from Products.WSPortal.Comments.Comments import Comment


def create_sanitations_object_callback(parent, id, contributor):
    ob = Sanitations(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()    
    return ob

class Sanitations(NyFolder):
    """ "Sanitations" section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ Load the initial data """
        # Add left portlets
        site = self.getSite()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]

        portlets_tool = site.getPortletsTool()
        portlets_tool.assign_portlet(location, position='left', portlet_id='facilities_search', inherit=True)
        portlets_tool.assign_portlet(location, position='left', portlet_id='sanitations_navigation', inherit=True)

    security.declarePublic('list_sanitations_localities')
    def list_sanitations_localities(self):
        """ Retrieve the list of sanitation facilities localities """
        localities = query.get_sanitations_localities(self.get_db_session())
        return [(loc[0], loc[1]) for loc in localities if loc]

    security.declarePublic('list_sanitations_functionalities')
    def list_sanitations_functionalities(self):
        """ Retrieve the list of sanitation facilities functionalities """
        functionalities = query.get_sanitations_functionalities(self.get_db_session())
        return [(fun[0], fun[1]) for fun in functionalities if fun]

    security.declarePublic('index_html')
    def index_html(self, REQUEST):
        """ Sanitation listing """
        items = query.filter_sanitations(self.get_db_session(),
                                    text=REQUEST.get('q', ''),
                                    id_subdivision = REQUEST.get('id_subdivision', ''),
                                    id_locality = REQUEST.get('id_locality', ''),
                                    functionality=REQUEST.get('func', ''),
                                    sort_on=REQUEST.get('sort', 'adloname'),
                                    sort_order=REQUEST.get('order', True))
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)

        return self._list(REQUEST, sanitations=items,
                        localities=self.list_sanitations_localities(),
                        functionalities=self.list_sanitations_functionalities())


    security.declareProtected(constants.REPORT_NON_INVENTORIED, 'add')
    def add(self, REQUEST):
        """
        Suggest non-inventoried sanitation facility.
        """
        session = self.get_db_session()
        error = subdivision = locality = None
        subdivisions = localities = parents = []
        repost = REQUEST.get('repost', False)
        level = 1

        default_coord = self.default_coordinates()
        map_centerx = default_coord['x']
        map_centery = default_coord['y']

        upisx = REQUEST.get('upisx', None)
        upisy = REQUEST.get('upisy', None)
        if upisx and upisy:
            map_centerx = upisx
            map_centery = upisy
        zoom = REQUEST.get('zoom', self.default_zoom)

        id_subdivision = REQUEST.get('subdivision', None)
        id_locality = REQUEST.get('adlocode', None)
        if id_subdivision:
            subdivision = access_queries.get_subdivision(session, REQUEST.get('subdivision'))
            parents = access_queries.get_subdivision_parents(session, subdivision)
            parents.append(subdivision)
            level = subdivision.level
            if subdivision.level == access_queries.get_subdivision_max(session):
                localities = access_queries.get_localities(session, subdivision).all() #SQLAlchemy query
            else:
                level += 1
                subdivisions = access_queries.get_subdivision_list(session, subdivision.code)
        else:
            subdivisions = access_queries.get_subdivision_list(session, id_subdivision)

        if id_locality:
            locality = access_queries.get_locality_by_code(session, id_locality)

        if REQUEST.form.has_key('btn-select-locality'):
            map_centerx = upisx = locality.adlox
            map_centery = upisy = locality.adloy
            zoom = self.default_zoom

        if REQUEST.form.has_key('btn-add-facility'):
            try:
                form = forms.AddSanitationFacilityForm.to_python(REQUEST.form, state=session)
            except validators.Invalid, e:
                error = e
            else:
                # Save in database
                form['upisupdate'] = datetime.now()
                form['upisupwho'] = REQUEST.AUTHENTICATED_USER.getUserName()
                upis, facility = facilities_queries.insert_new_sanitation_facility(session, form)
                #coverage = locality.adloname + ', ' + subdivision.name
                #keywords = ', '.join(['Sanitation facility'])
                #geo_kwargs = {'geo_location.lat': '%s' % upis.upisy, 'geo_location.lon': '%s' % upis.upisx}

                photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/facilities', context=self,
                                            album_id=upis.upiscode, album_title='')

                # Save in pictures in ZoDB
                for k in REQUEST.form.keys():
                    if k.startswith('file'):
                        #keywords = ['sanitation facility']
                        #@todo: save main_use, wp_type, etc
                        kwargs = {}
                        if locality:
                            kwargs['coverage'] = '%s, %s' % (locality.adloname, locality.subdivision.name)
                        kwargs['geo_location.lat'] = str(upis.upisy)
                        kwargs['geo_location.lon'] = str(upis.upisx)
                        photo_gallery.add_photo('', REQUEST.form[k], **kwargs)

                return REQUEST.RESPONSE.redirect(self.finish.absolute_url())
        return self._add(REQUEST, upisx = upisx, upisy=upisy, zoom=zoom,
            id_subdivision = id_subdivision, id_locality = id_locality,
            subdivisions = subdivisions, localities = localities, level = level,
            parents = parents, error = error, repost=repost,
            map_centerx = map_centerx, map_centery = map_centery)


    security.declareProtected(constants.EDIT_DATA, 'approve')
    def approve(self, REQUEST):
        """ approve sanitation facility """
        session = self.get_db_session()
        id = REQUEST.get('id', '')
        errors = []

        photo_gallery = PhotoUpload(gallery = 'resources/multimedia/photos/facilities', context=self,
                                    album_id = id, album_title = '')

        if REQUEST.form.has_key('delete'):
            update.delete_sanitation_facility(session, id)
            photo_gallery.delete_album()
            return REQUEST.RESPONSE.redirect('%s/pending?type=sanitations&del=ok' % self.absolute_url())

        elif REQUEST.form.has_key('approve'):
            errors = validation.validate_sanitation_facility_approval(session, REQUEST.form)
            if not errors:
                upisx = REQUEST.form['upisx']
                upisy = REQUEST.form['upisy']
                # Update database data
                update.approve_facility(session, id, upisx, upisy)
                return REQUEST.RESPONSE.redirect('%s/pending?type=sanitations&app=ok' % self.absolute_url())

        elif REQUEST.form.has_key('delete-photos'):
            for photo in self.utConvertToList(REQUEST.form.get('ids', [])):
                photo_gallery.delete_photo(photo)

        sanitation = query.get_pending_sanitation_facility_by_id(self.get_db_session(), id)
        locality = access_queries.get_locality_by_code(session, sanitation.adlocode)
        upisloctype = query.get_lexicon_row(session, Lexicon.LexUpisloctype, sanitation.upisloctype)
        upisobj = query.get_lexicon_row(session, Lexicon.LexWP051, sanitation.upisobj)

        upisx = sanitation.upisx
        upisy = sanitation.upisy
        zoom = self.default_zoom

        return self._approve(REQUEST, locality=locality, sanitation=sanitation,
                                        upisobj=upisobj, upisloctype=upisloctype,
                                        upisx=upisx, upisy=upisy,
                                        zoom=zoom, errors=errors, photo_gallery=photo_gallery)

    security.declarePublic('map')
    def map(self, REQUEST):
        """ Display the map with sanitation facilities """
        upisx = REQUEST.get('upisx', self.default_longitude)
        upisy = REQUEST.get('upisy', self.default_latitude)
        zoom = self.default_zoom
        zoom = REQUEST.get('zoom', self.default_zoom)
        return self._map(REQUEST, upisx=upisx, upisy=upisy, zoom=zoom,
                                     localities=self.list_sanitations_localities(),
                                     functionalities=self.list_sanitations_functionalities())


    security.declarePublic('view')
    def view(self, REQUEST):
        """ sanitation facility index """

        id = REQUEST.get('id', '')
        session = self.get_db_session()
        report_errors = report_success = None

        private = False
        if REQUEST.get('details', '') and not self.isAnonymousUser():
            private = True

        sanitation = access_queries.get_sanitation(session, id)

        comments_tool = Comment(model = UpisComment, code = sanitation.upiscode,
                                session = session, context = self)

        photo_gallery = PhotoUpload(gallery = 'resources/multimedia/photos/facilities', context=self,
                                    album_id = sanitation.upiscode, album_title = '')

        #report non-functioning waterpoint
        if REQUEST.form.has_key('btn-report-sanitation'):
            report_errors, report_success = self.report_non_functioning(code = sanitation.upiscode,
                                                                        template = 'report_sanitation',
                                                                        REQUEST = REQUEST)

        #upload photo
        if REQUEST.form.has_key('btn-submit-photo') and self.checkPermissionPostPhoto():
            title = REQUEST.form.get('title', '')
            file = REQUEST.form.get('file', None)
            kwargs = {}
            kwargs['coverage'] = '%s, %s' % (sanitation.locality.adloname, sanitation.locality.subdivision.name)

            keywords = ['sanitation facility']
            if sanitation.sftype:
                keywords.append(sanitation.sftype.name)
            if sanitation.upisobj_name:
                keywords.append(sanitation.upisobj_name)
            kwargs['keywords'] = ','.join(keywords)
            kwargs['geo_location.lat'] = str(sanitation.upisy)
            kwargs['geo_location.lon'] = str(sanitation.upisx)
            photo_gallery.add_photo(title, file, **kwargs)

        #add comment
        if REQUEST.form.has_key('btn-add-comment'):
            comments_tool.add_comment(REQUEST)

        return self._view(REQUEST,
                            sanitation=sanitation,
                            photo_gallery = photo_gallery,
                            errors_photo = photo_gallery.errors,
                            comments_tool = comments_tool,
                            errors = comments_tool.errors,
                            report_success = report_success,
                            report_errors = report_errors,
                            private = private)

    _view = NaayaPageTemplateFile('zpt/sanitations/view', globals(), 'ws_facilities_sanitation')
    _list = NaayaPageTemplateFile('zpt/sanitations/list', globals(), 'ws_facilities_list_sanitations')
    _map = NaayaPageTemplateFile('zpt/sanitations/map', globals(), 'ws_facilities_map_sanitation')
    _add = NaayaPageTemplateFile('zpt/sanitations/add', globals(), 'ws_facilities_add_sanitation')
    _approve = NaayaPageTemplateFile('zpt/sanitations/approve', globals(), 'ws_facilities_approve_sanitation')


InitializeClass(Sanitations)
