#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder

#Watsan imports
from ws.common.sql.queries import PipedWaterSchemes as pws_queries
from ws.common.sql.queries import Facilities as facilities_queries
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from ws.common.utilities.photo_upload.PhotoUpload import PhotoUpload

from Products.WSPortal.Comments.models import UpisComment
from Products.WSPortal.Comments.Comments import Comment
from ws.common.sql.queries.Access import get_subdivision_upis


def create_pipedwaterschemes_object_callback(parent, id, contributor):
    ob = PipedWaterSchemes(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    ob.loadDefaultData()
    return ob



class PipedWaterSchemes(NyFolder):
    """ "PipedWaterSchemes" section of the portal """

    security = ClassSecurityInfo()

    security.declarePrivate('loadDefaultData')
    def loadDefaultData(self, *args, **kwargs):
        """ Load the initial data """
        # Add left portlets
        site = self.getSite()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]

        portlets_tool = site.getPortletsTool()
        portlets_tool.assign_portlet(location, position='left', portlet_id='facilities_search', inherit=True)
        portlets_tool.assign_portlet(location, position='left', portlet_id='pws_navigation', inherit=True)

    security.declarePublic('view')
    def view(self, REQUEST):
        """ piped water scheme index """
        id = REQUEST.get('id', '')
        session = self.get_db_session()

        private = False
        if REQUEST.get('details', '') and not self.isAnonymousUser():
            private = True

        pws = pws_queries.get_piped_water_scheme(session, id)
        subdivision = get_subdivision_upis(session, pws)
        hierarchy = [None]
        if subdivision:
            hierarchy = facilities_queries.get_subdivision_hierarchy(session, subdivision)

        comments_tool = Comment(model = UpisComment, code = pws.upiscode, 
                                session = session, context = self)
        photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/piped_water_schemes', 
                                    context=self, album_id=pws.upiscode, album_title='')

        #upload photo
        if REQUEST.form.has_key('btn-submit-photo') and self.checkPermissionPostPhoto():
            title = REQUEST.form.get('title', '')
            file = REQUEST.form.get('file', None)
            kwargs = {}
            kwargs['coverage'] = '%s, %s' % (pws.locality.adloname, pws.locality.subdivision.name)

            keywords = ['piped water scheme']
            kwargs['keywords'] = ', '.join(keywords)
            kwargs['geo_location.lat'] = str(pws.upisy)
            kwargs['geo_location.lon'] = str(pws.upisx)
            photo_gallery.add_photo(title, file, **kwargs)

        #add comment
        if REQUEST.form.has_key('btn-add-comment'):
            comments_tool.add_comment(REQUEST)

        #populate tab data if requested
        tab_data = None
        upisx = pws.upisx
        upisy = pws.upisy
        zoom = self.default_zoom

        tab = REQUEST.get('tab', 'WP')
        if tab == 'WP':
            tab_data = pws_queries.get_water_points(session, id)
        if tab == 'plan':
            upisx = None
            upisy = None
            zoom = None
        if tab == 'energy':
            tab_data = pws_queries.get_energy_source(session, id)
        if tab == 'piping':
            tab_data = pws_queries.get_piping(session, id)
        if tab == 'pumping':
            tab_data = pws_queries.get_pumping(session, id)
        if tab == 'reservoirs':
            tab_data = pws_queries.get_reservoirs(session, id)
        if tab == 'treatment':
            tab_data = pws_queries.get_water_treatment(session, id)

        level1_subdivision = None
        if hierarchy:
            level1_subdivision = hierarchy[0]

        return self._view(REQUEST,
                            pws = pws,
                            photo_gallery = photo_gallery,
                            errors_photo = photo_gallery.errors,
                            comments_tool = comments_tool,
                            errors = comments_tool.errors,
                            private = private,
                            level1_subdivision = level1_subdivision,
                            tab_data = tab_data,
                            subdivision = subdivision,
                            upisx = upisx, upisy = upisy, zoom = zoom)


    security.declarePublic('list_piped_water_schemes_localities')
    def list_piped_water_schemes_localities(self):
        """ Retrieve the list of piped water schemes localities """
        localities = pws_queries.get_piped_water_schemes_localities(self.get_db_session())
        return [(loc[0], loc[1]) for loc in localities if loc and loc[0] and loc[1]]


    security.declarePublic('list_piped_water_schemes_functionalities')
    def list_piped_water_schemes_functionalities(self):
        """ Retrieve the list of piped water schemes functionalities """
        functionalities = pws_queries.get_piped_water_schemes_functionalities(self.get_db_session())
        return [(fun[0], fun[1]) for fun in functionalities if fun and fun[0] and fun[1]]


    security.declarePublic('index_html')
    def index_html(self, REQUEST):
        """ piped water schemes listing """
        items = pws_queries.filter(self.get_db_session(),
                                    query_string=REQUEST.get('q', ''),
                                    id_subdivision = REQUEST.get('id_subdivision', ''),
                                    id_locality = REQUEST.get('id_locality', ''),
                                    functionality=REQUEST.get('func', ''),
                                    sort_on=REQUEST.get('sort', ''),
                                    sort_order=REQUEST.get('order', True))
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)

        return self._list(REQUEST, piped_water_schemes=items,
                localities=self.list_piped_water_schemes_localities(),
                functionalities=self.list_piped_water_schemes_functionalities())


    security.declarePublic('map')
    def map(self, REQUEST):
        """ Piped water schemes map """
        upisx = REQUEST.get('upisx', self.default_longitude)
        upisy = REQUEST.get('upisy', self.default_latitude)
        zoom = REQUEST.get('zoom', self.default_zoom)
        return self._map(REQUEST, upisx=upisx, upisy=upisy, zoom=zoom,
                    localities=self.list_piped_water_schemes_localities(),
                    functionalities=self.list_piped_water_schemes_functionalities())

    _view = NaayaPageTemplateFile('zpt/pws/view', globals(), 'ws_facilities_piped_water_scheme')
    _list = NaayaPageTemplateFile('zpt/pws/list', globals(), 'ws_facilities_list_piped_water_schemes')
    _map = NaayaPageTemplateFile('zpt/pws/map', globals(), 'ws_facilities_map_piped_water_scheme')


InitializeClass(PipedWaterSchemes)
