from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, DateTime, Integer, Float, Date, Boolean
from sqlalchemy.orm import mapper, relation

from ws.common.sql.mappings.Upis import Upis
from ws.common.sql.mappings.Locality import Locality
from ws.common.sql.mappings.Subdivision import Subdivision

metadata = MetaData()
upis_comments_table = Table('t_upis_comments', metadata,
        Column('id', Integer, primary_key=True),                #Identifier for the comment
        Column('code', String, ForeignKey(Upis.upiscode)),      #Identifier for the commented item
        Column('user', String),                                 #Identifier for the user who posted the comment
        Column('user_name', String),                            #User's name
        Column('user_email', String),                           #User's email address
        Column('submit_date', DateTime),                        #Date of the post
        Column('rating', Integer),                              #Rating given by user
        Column('comment', String),                              #Rating given by user
        Column('ip_address', String),                           #IP address of the commenter
        Column('is_public', Boolean),                           #Restrict the comment for anonymous users
        Column('is_removed', Boolean),                          #Mark the comment as deleted
)

class UpisComment(object):
    """
    Mapping for upis table (t_upis_comments)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(UpisComment, upis_comments_table)


adloc_comments_table = Table('t_adloc_comments', metadata,
        Column('id', Integer, primary_key=True),                #Identifier for the comment
        Column('code', String, ForeignKey(Locality.adlocode)),  #Identifier for the commented item
        Column('user', String),                                 #Identifier for the user who posted the comment
        Column('user_name', String),                            #User's name
        Column('user_email', String),                           #User's email address
        Column('submit_date', DateTime),                        #Date of the post
        Column('rating', Integer),                              #Rating given by user
        Column('comment', String),                              #Rating given by user
        Column('ip_address', String),                           #IP address of the commenter
        Column('is_public', Boolean),                           #Restrict the comment for anonymous users
        Column('is_removed', Boolean),                          #Mark the comment as deleted
)

class LocComment(object):
    """
    Mapping for locality table (t_adloc_comments)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LocComment, adloc_comments_table)


adreglev_comments_table = Table('t_adreglev_comments', metadata,
        Column('id', Integer, primary_key=True),                #Identifier for the comment
        Column('code', String, ForeignKey(Subdivision.code)),   #Identifier for the commented item
        Column('user', String),                                 #Identifier for the user who posted the comment
        Column('user_name', String),                            #User's name
        Column('user_email', String),                           #User's email address
        Column('submit_date', DateTime),                        #Date of the post
        Column('rating', Integer),                              #Rating given by user
        Column('comment', String),                              #Rating given by user
        Column('ip_address', String),                           #IP address of the commenter
        Column('is_public', Boolean),                           #Restrict the comment for anonymous users
        Column('is_removed', Boolean),                          #Mark the comment as deleted
)

class RegionComment(object):
    """
    Mapping for subdivion table (t_adreglev_comments)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(RegionComment, adreglev_comments_table)

