from formencode import Schema, validators, Invalid
from formencode.validators import FormValidator

class RequireIfMissing(FormValidator):
    """  """

    required = None
    missing = None
    present = None
    __unpackargs__ = ('required',)

    def _to_python(self, value_dict, state):
        is_required = False
        if self.missing and not value_dict.get(self.missing):
            is_required = True
        if self.present and value_dict.get(self.present):
            is_required = True
        if is_required and not value_dict.get(self.required):
            raise Invalid('You must give a value for %s' % self.required,
                          value_dict, state,
                          error_dict={self.required: Invalid(self.message(
                              'empty', state), value_dict, state)})
        return value_dict

RequireIfPresent = RequireIfMissing

class CommentForm(Schema):
    """ """
    user = validators.String()
    user_name = validators.String(if_missing=None)
    user_email = validators.Email(if_missing=None)
    comment = validators.String(not_empty=True)
    rating = validators.Int()
    filter_extra_fields = True
    allow_extra_fields = True
    chained_validators = [RequireIfMissing('user_name', missing='user'),
                          RequireIfMissing('user_email', missing='user')]