from OFS import Folder
from Products.WSPortal.Access.WSPortalAccess import WSPortalAccess
import zLOG


__doc__ = """Access portal section"""
__version__ = '0.0.1'


def initialize(context):
    """ 
        Product initialization method
        @param context: Zope server context 
    """
    try:
        context.registerClass(
            WSPortalAccess,
            constructors = (
                Folder.manage_addFolderForm,
                Folder.manage_addFolder),
        )
    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        zLOG.LOG(__name__, zLOG.ERROR, 'An error occurred during product initialization. No WatSan country portal "Access" section available', error = (type, val, tb), reraise=True)
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb
