'''
Created on Feb 4, 2010

@author: cristiroma
'''
from sqlalchemy.orm.exc import NoResultFound
from ws.common.sql.mappings.Lexicon import UpistypeEnum
import sys

from AccessControl.SecurityInfo import ClassSecurityInfo
from Globals import InitializeClass
import zLOG

from Products.Naaya.NyFolder import NyFolder
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile

from ws.common import get_current_year
from ws.common.statistics.Locality import AccessLocalityStats
from ws.common.sql.queries import Access as access_query
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage
from ws.common.utilities.photo_upload.PhotoUpload import PhotoUpload

from Products.WSPortal.Comments.models import LocComment, RegionComment
from Products.WSPortal.Comments.Comments import Comment


def create_wsportalaccess_object_callback(parent, id, contributor):
    ob = WSPortalAccess(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob


class WSPortalAccess(NyFolder):
    """
    "Access" section of the portal
    """
    security = ClassSecurityInfo()

    security.declarePublic('get_current_year')
    def get_current_year(self):
        return get_current_year()


    security.declarePublic('portlet_qn_data')
    def portlet_qn_data(self, id=None):
        """ Data necessary to render quick-navigation portlet """
        ret = {
               'subdivisions' : [], 
               'localities' : [], 
               'names' : {
                          1 : 'Subdivision level 1',
                          2 : 'Subdivision level 2',
                          3 : 'Subdivision level 3',
                          4 : 'Subdivision level 4',
                          5 : 'Subdivision level 5',
               }
        }

        ret_subdivisions = []
        subdivision = None
        session = self.get_db_session()

        if id:
            try:
                locality = access_query.get_locality_by_code(session, id)
                subdivision = access_query.get_subdivision(session, locality.loadrcode)
            except:
                try:
                    subdivision = access_query.get_subdivision(session, id)
                except NoResultFound:
                    pass
        

        if subdivision:
            max_level = access_query.get_subdivision_max(session)
            level = subdivision.level
            ob = subdivision

            if level < max_level:
                dd = {}
                dd['level'] = level + 1
                dd['subdivisions'] = access_query.get_subdivision_list(session, ob.code)
                dd['selected'] = None
                ret_subdivisions.append(dd)

            while(ob is not None):
                dd = {}
                dd['level'] = ob.level
                dd['subdivisions'] = access_query.get_subdivision_list(session, ob.parent_code)
                dd['selected'] = ob.id
                ret_subdivisions.append(dd)
                ob = access_query.get_subdivision(session, ob.parent_code)

            ret_subdivisions.reverse()
            if level == max_level:
                dd = {}
                dd['level'] = None
                dd['localities'] = access_query.get_localities(session, subdivision)
                dd['selected'] = id
                ret['localities'] = dd
        else:
            dd = {}
            dd['level'] = 1
            dd['subdivisions'] = access_query.get_subdivisions_by_level(session, 1)
            dd['selected'] = None
            ret_subdivisions.append(dd)
        ret['subdivisions'] = ret_subdivisions
        return ret


    security.declarePublic('get_subdivision')
    def get_subdivision(self, code):
        """ """
        session = self.aq_parent.get_db_session()
        return access_query.get_subdivision(session, code)


    security.declarePrivate('get_locality_by_name')
    def get_locality_by_name(self, locality_name):
        session = self.aq_parent.get_db_session()
        try:
            ret = access_query.get_locality_by_name(session, locality_name)
        except:
            ret = None
        return ret


    security.declarePublic('subdivision_statistics_on_localities')
    def subdivision_statistics_on_localities(self, subdivision, page=1, type=UpistypeEnum.WP):
        """ Compute the statistical data for each tab in subdivision index page """
        session = self.get_db_session()
        items = access_query.get_localities(session, subdivision)
        paginator = DiggPaginator(items, 20, body=5, padding=2, orphans=10)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(page)
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            page_object = paginator.page(page)
        except (EmptyPage, InvalidPage):
            page_object = paginator.page(paginator.num_pages)

        # Get statistical data for localities within page only
        objects_list = access_query.subdivision_statistics_on_localities(session, page_object.objects_list, type)
        page_object.objects_list = objects_list
        return page_object

    security.declarePublic('index_html')
    def index_html(self, REQUEST):
        """ Country access index page """
        year = get_current_year()
        session = self.get_db_session()
        overview = access_query.get_country_access_overview(session, self.getSite().country_code)
        history = access_query.get_country_access_history(session)
        subdivision_access = access_query.get_subdivision_access(session, level=1)
        return self._index_html(REQUEST, year = year, overview = overview, history=history, subdivision_access=subdivision_access)

    security.declarePublic('subdivision')
    def subdivision(self, REQUEST):
        """ Index page for subdivision """
        id = REQUEST.get('id', '')
        stats = None

        private = False
        if REQUEST.get('details', '') and not self.isAnonymousUser():
            private = True

        if id:
            session = self.get_db_session()
            subdivision = access_query.get_subdivision(session, id)
            max_level = access_query.get_subdivision_max(session)
            try:
                stats = access_query.get_subdivision_stats(session, id)
            except:
                zLOG.LOG(__name__, zLOG.WARNING, 'WSPortalAccess::subdivision() Error getting statistical data for (%s)' % (subdivision.name), error = sys.exc_info(), reraise=False)

            photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/subdivisions', context=self,
                                        album_id=subdivision.code, album_title=subdivision.name)


            comments_tool = Comment(model = RegionComment, code = subdivision.code,
                                    session = session, context = self)

            #upload photo
            if REQUEST.form.has_key('btn-submit-photo') and self.checkPermissionPostPhoto():
                title = REQUEST.form.get('title', '')
                file = REQUEST.form.get('file', None)
                kwargs = {}
                kwargs['coverage'] = subdivision.name
                kwargs['keywords'] = 'subdivision, %s' % subdivision.name
                photo_gallery.add_photo(title, file, **kwargs)

            #add comment
            if REQUEST.form.has_key('btn-add-comment'):
                comments_tool.add_comment(REQUEST)

            if subdivision.level < max_level:
                subdivision_access = access_query.get_subdivision_access(session, level=subdivision.level + 1, parent=subdivision.code)
                return self._subdivision(REQUEST,
                                         id = id,
                                         subdivision = subdivision,
                                         photo_gallery = photo_gallery,
                                         errors_photo = photo_gallery.errors,
                                         comments_tool = comments_tool,
                                         errors = comments_tool.errors,
                                         success = comments_tool.success,
                                         stats = stats,
                                         private = private,
                                         subdivision_access = subdivision_access)
            return self._subdivision_last_level(REQUEST,
                                                id = id,
                                                subdivision = subdivision,
                                                photo_gallery = photo_gallery,
                                                errors_photo = photo_gallery.errors,
                                                comments_tool = comments_tool,
                                                errors = comments_tool.errors,
                                                success = comments_tool.success,
                                                stats = stats,
                                                private = private)


    security.declarePublic('locality')
    def locality(self, REQUEST):
        """ Index page for locality """
        
        id = REQUEST.get('id', '')
        session = self.get_db_session()

        private = False
        if REQUEST.get('details', '') and not self.isAnonymousUser():
            private = True

        stats = locality = None
        try:
            locality = access_query.get_locality_by_code(session, id)
        except NoResultFound:
            zLOG.LOG(__name__, zLOG.WARNING, 'No locality found for the id %s' % id)

        if locality:
            locality_stats = None
            try:
                locality_stats = access_query.get_locality_statistics(session, locality.adlocode)
            except NoResultFound:
                zLOG.LOG(__name__, zLOG.WARNING, 'No statistical data computed for %s' % locality.adloname)
            stats = AccessLocalityStats(session, locality)

            photo_gallery = PhotoUpload(gallery='resources/multimedia/photos/localities',
                                        album_id=id,
                                        album_title=locality.adloname,
                                        context=self)

            comments_tool = Comment(model = LocComment, code = locality.adlocode,
                                    session = session, context = self)


            #upload photo
            if REQUEST.form.has_key('btn-submit-photo') and self.checkPermissionPostPhoto():
                title = REQUEST.form.get('title', '')
                file = REQUEST.form.get('file', None)
                kwargs = {}
                kwargs['coverage'] = '%s, %s' % (locality.adloname, locality.subdivision.name)
                keywords = ['locality']
                if locality.adlohgroup_ob:
                    keywords.append(locality.adlohgroup_ob.name)
                kwargs['keywords'] = ', '.join(keywords)
                kwargs['geo_location.lat'] = str(locality.adloy)
                kwargs['geo_location.lon'] = str(locality.adlox)
                photo_gallery.add_photo(title, file, **kwargs)
    
            #add comment
            if REQUEST.form.has_key('btn-add-comment'):
                comments_tool.add_comment(REQUEST)
    
            return self._locality(REQUEST,
                            locality = locality,
                            locality_stats = locality_stats,
                            stats = stats,
                            photo_gallery = photo_gallery,
                            errors_photo = photo_gallery.errors,
                            comments_tool = comments_tool,
                            errors = comments_tool.errors,
                            success = comments_tool.success,
                            private = private)
        return self._locality(REQUEST)


    security.declarePublic('localities')
    def localities(self, REQUEST):
        """ Localities page """
        session = self.get_db_session()

        subdivision = access_query.get_subdivision(session, REQUEST.get('id', None))
        localities = access_query.get_localities_statistics(session,
                                                            REQUEST.get('q', ''),
                                                            subdivision, 
                                                            sort_on=REQUEST.get('sort', 'adloname'),
                                                            sort_order=REQUEST.get('order', True))

        paginator = DiggPaginator(localities, 20, body=5, padding=2, orphans=10)   #Show 20 documents per page

        # Make sure page request is an int. If not, deliver first page.
        try:
            page = int(REQUEST.get('page', '1'))
        except ValueError:
            page = 1

        # If page request (9999) is out of range, deliver last page of results.
        try:
            items = paginator.page(page)
        except (EmptyPage, InvalidPage):
            items = paginator.page(paginator.num_pages)

        return self._localities(REQUEST, localities=items)


    _localities = NaayaPageTemplateFile('zpt/localities', globals(), 'ws_access_localities')
    _index_html = NaayaPageTemplateFile('zpt/country', globals(), 'ws_access_country')
    _subdivision = NaayaPageTemplateFile('zpt/subdivision', globals(), 'ws_access_subdivision')
    _subdivision_last_level = NaayaPageTemplateFile('zpt/subdivision_last_level', globals(), 'ws_access_subdivision')
    _locality = NaayaPageTemplateFile('zpt/locality', globals(), 'ws_access_locality')
    template_access_html = NaayaPageTemplateFile('zpt/template_access', globals(), 'ws_access_template')


InitializeClass(WSPortalAccess)

