dojo.provide('umap.customizations.ProgramsMapClick');
dojo.require('umap.ClickHandler');


OpenLayers.Control.ProgramsMapClick = OpenLayers.Class(umap.ClickHandler, {

	trigger: function(e) {
		var map = e.object;
		this.busyCursor(map, true);
		try {
			var visible_gis_layers = this.ut_findGISLayers(map.layers);
            var gis_layers = [];

            // Filter out unimportant layers:
            for(var i = 0; i < visible_gis_layers.length; i++) {
                var layer = visible_gis_layers[i];
                if( layer.params.layers == 'project_subdivisions' || layer.params.layers == 'project_localities') {
                    gis_layers.push(layer);
                }
            }


            // From visible layers see which ones are good for querying (only project_subdivisions, project_localities)
            var _this = this;
            var processed = 0;
            var required = gis_layers.length;
            var localities = [];
            var iHandler = setInterval(function() {
                if (processed == required) {
                    clearInterval(iHandler);
                    _this.processClick(map, e.xy, localities);
                }
            }, 50);

            for(var i = 0; i < gis_layers.length; i++) {
                var layer = gis_layers[i];
                var url  = this.ut_query_layer_url(layer, map, e.xy);
                OpenLayers.loadURL(url, '', this, function(data) {
                    objects = _this.parseResponse(e.xy, map, data);
                    for( i = 0; i < objects.length; i++) {
                        var object = objects[i];
                        if('adlocode' in object.data) {
                            localities.push(object);
                        }
                    }
                    processed += 1;
                    return null;
                });
            }
		} catch(e) {
			this.busyCursor(map, false);
			throw e;
		}
	},

    processClick : function(map, xy, localities) {
		var url = UMAP_SETTINGS.server_url;
        var total_len = localities.length;
        if(total_len > 1) {
			var html = '<h2>Multiple points found</h2><br />Please zoom in to see details';
            var popup = new OpenLayers.Popup.FramedCloud('SFMAP', map.getLonLatFromPixel(xy), null, html, null, true);
			map.addPopup(popup, true);
        } else {
            if(localities.length == 1) {
				url += '/access/locality?id=' + localities[0].attributes.adlocode;
				window.open(url);
            }
        }
        this.busyCursor(map, false);
    },

	parseResponse : function(xy, map, response) {
        var ret = [];
		try {
			var format = new OpenLayers.Format.WMSGetFeatureInfo();
			ret = format.read(response.responseText);
		} catch(e) {
			this.busyCursor(map, false);
			throw e;
		}
		this.busyCursor(map, false);
        return ret;
	}
});
