dojo.provide('umap.customizations.PipedWaterSchemesMapClick');
dojo.require('umap.ClickHandler');


OpenLayers.Control.PipedWaterSchemesMapClick = OpenLayers.Class(umap.ClickHandler, {

	trigger: function(e) {
		var map = e.object;
		this.busyCursor(map, true);
		try {
			var gis_layers = this.ut_findGISLayers(map.layers);
			var url = this.ut_gis_basic_url(gis_layers, map, e.xy);
			if(url) {
				OpenLayers.loadURL(url, '', this, function(data) {this.parseResponse(e.xy, map, data);});
			}
		} catch(e) {
			this.busyCursor(map, false);
			throw e;
		}
	},


	parseResponse : function(xy, map, response) {
		try {
			var format = new OpenLayers.Format.WMSGetFeatureInfo();
			var features = format.read(response.responseText);
			if(features.length > 1) {
				var html = 'Multiple water points found.<br />Zoom in to select individual points';
				map.addPopup(new OpenLayers.Popup.FramedCloud('WTPMAP', map.getLonLatFromPixel(xy), null, html, null, true));
			} else if(features.length == 1) {
				// Go to the waterpoint
				var url = UMAP_SETTINGS.server_url + '/facilities/pipedwaterschemes/view?id=' + features[0].attributes.upiscode;
				window.open(url);
			}
		} catch(e) {
			this.busyCursor(map, false);
			throw e;
		}
		this.busyCursor(map, false);
	}
});
