dojo.provide('umap.customizations.IWRMMapIndexClick');
dojo.require('umap.ClickHandler');


OpenLayers.Control.IWRMMapIndexClick = OpenLayers.Class(umap.ClickHandler, {

	trigger: function(e) {
		var map = e.object;
		this.busyCursor(map, true);
		try {
			var gis_layers = this.ut_findGISLayers(map.layers);
			var _this = this;
			var processed = 0;
			var required = gis_layers.length;
			
			var ob_mostation = [];
			var ob_uws = [];
			var ob_basin = [];
			var ob_aquifer = [];
			var ob_river = [];

			var iHandler = setInterval(function() {
				if (processed == required) {
					clearInterval(iHandler);
					_this.processClick(map, e.xy, ob_mostation, ob_uws, ob_basin, ob_aquifer, ob_river);
				}
			}, 50);

			for(var i = 0; i < gis_layers.length; i++) {
				var layer = gis_layers[i];
				var url  = this.ut_query_layer_url(layer, map, e.xy);
				OpenLayers.loadURL(url, '', this, function(data) {
					var objects = _this.parseResponse(e.xy, map, data);
					for( i = 0; i < objects.length; i++) {
						var object = objects[i];
						if(object.type == 'iwrm_mostation')
							ob_mostation.push(object);

						if(object.type == 'iwrm_uws')
							ob_uws.push(object);

						if(object.type == 'iwrm_basin')
							ob_basin.push(object);

						if(object.type == 'iwrm_aquifer')
							ob_aquifer.push(object);

						if(object.type == 'iwrm_river')
							ob_river.push(object);
					}
					processed += 1;
					return null;
				});
			}
		} catch(e) {
			this.busyCursor(map, false);
			throw e;
		}
	},


	processClick : function(map, xy, ob_mostation, ob_uws, ob_basin, ob_aquifer, ob_river) {
		var total_len = ob_mostation.length + ob_uws.length + ob_basin.length + ob_aquifer.length + ob_river.length;

		if(total_len > 1) {
			var html = '<h2>Multiple items found</h2><br />Please zoom in to see details';
			var popup = new OpenLayers.Popup.FramedCloud('SFMAP', map.getLonLatFromPixel(xy), null, html, null, true);
			map.addPopup(popup, true);
		} else {
			var url = null;

			if(ob_mostation.length == 1) {
				url = UMAP_SETTINGS.server_url + '/iwrm/balloon_mostation?id=' + ob_mostation[0].data.moscode;
			}
			if(ob_uws.length == 1) {
				url = UMAP_SETTINGS.server_url + '/iwrm/balloon_uws?id=' + ob_uws[0].data.upiscode;
			}
			if(ob_basin.length == 1) {
				url = UMAP_SETTINGS.server_url + '/iwrm/balloon_basin?id=' + ob_basin[0].data.ID;
			}
			if(ob_aquifer.length == 1) {
				url = UMAP_SETTINGS.server_url + '/iwrm/balloon_aquifer?id=' + ob_aquifer[0].data.ID;
			}
			if(ob_river.length == 1) {
				url = UMAP_SETTINGS.server_url + '/iwrm/balloon_river?id=' + ob_river[0].data.ID;
			}

			OpenLayers.loadURL(url, '', this, function(data) {
				var popup = new OpenLayers.Popup.FramedCloud('SFMAP', map.getLonLatFromPixel(xy), null, data.responseText, null, true);
				map.addPopup(popup, true);
			});
		}
		this.busyCursor(map, false);
	},

	parseResponse : function(xy, map, response) {
		var ret = []
		try {
			var format = new OpenLayers.Format.WMSGetFeatureInfo();
			ret = format.read(response.responseText);
		} catch(e) {
			this.busyCursor(map, false);
			throw e;
		}
		this.busyCursor(map, false);
		return ret;
	}
});
