dojo.provide('umap.Utilities');

/**
 * Handle exception
 * @param message Additional exception message
 * @param ex Raised exception
 * @param rethrow If true rethrows the exception
 * @return Nothing
 */
function handleException(message, ex, rethrow) {
	var exception_msg = '';
	
	if(ex.message) {
		exception_msg = ex.message + ' ';
	}
	if(ex.name) {
		exception_msg += '(' + ex.name + '): '; 
	}
	if(ex.fileName) {
		exception_msg += ' in ' + ex.fileName;
	}
	if(ex.lineNumber) {
		exception_msg += '@' + ex.lineNumber;
	}
	exception_msg = exception_msg + ex;
	alert(message + '.\n' + exception_msg);
	if(ex && rethrow) {
		throw ex;
	}
}


function umap_warn(message) {
	try {
		if(UMAP_DEBUG) {
			alert(message);
		}
	} catch(e) {}
}

/**
 * Clear all the features from the vector layers of the map
 * @param map OpenLayers.Map object
 * @param firstOnly Clear only the first found vector layer
 * @return null
 */
function umap_clearFeatures(map, firstOnly) {
	// Find tge Vector layer and clear its features
	for(var i = 0; i < map.layers.length; i++) {
		var layer = map.layers[i];
		if (layer instanceof OpenLayers.Layer.Vector) {
			layer.removeFeatures(layer.features);
			if(firstOnly)
				break;
		}
	}
}

/**
 * Retrieve the first vector layer available within the map
 * @param map OpenLayers.Map object
 * @return Object of type OpenLayers.Layer.Vector or null if none found.
 */
function umap_getFirstVectorLayer(map) {
	for(var i = 0; i < map.layers.length; i++) {
		var layer = map.layers[i];
		if (layer instanceof OpenLayers.Layer.Vector) {
			return layer;
		}
	}
}

/**
 * Create an OpenLayers.Feature.Vector object, representable on the map.
 * @param map Map object
 * @param clon longitude in SphericalMercator coordinates
 * @param clat
 * @return
 */
function umap_makePoint(map, clon, clat) {
	var point = new OpenLayers.Geometry.Point(clon, clat);
	var proj4326 = new OpenLayers.Projection("EPSG:4326");
	point = point.transform(proj4326, map.getProjectionObject());
	return new OpenLayers.Feature.Vector(point);
}
