dojo.provide('umap.UMap');
dojo.require('umap.Utilities');
dojo.require('umap.ClickHandler');
dojo.require("dojox.string.sprintf");


dojo.declare('umap.UMap', null, {
	constructor : function(cfg) {
		this.cfg = cfg;
		this.validate();
		this.map = null;
		this.settings = null;
		this.backgrounds = [];
		this.overlays = [];
	},


	validate : function() {
		try {
			var config = this.cfg;
			if(config) {
				var map = config.map;
				if(map) {
					if(map.div == null || map.div == '') {
						throw "UMap::validate(): Invalid setting for map.div parameter";
					}
					if(!map.center) {
						throw "UMap::validate() : Missing setting 'map.center'";
					} else {
						if(typeof(map.center) !== typeof({})) throw dojox.string.sprintf("UMap::validate() : Invalid setting for 'map.center'. Array must have exactly 3 elements lat/lon/zoom ([%s])", this.cfg.map.center);
						if(typeof(map.center.lat) == 'undefined') throw "UMap::validate() : Invalid setting for 'map.center.lat'";
						if(typeof(map.center.lon) == 'undefined') throw "UMap::validate() : Invalid setting for 'map.center.lon'";
						if(typeof(map.center.zoom) == 'undefined') throw "UMap::validate() : Invalid setting for 'map.center.zoom'";
					}
				} else {
					throw "UMap::validate(): Improperly configured library (missing this.cfg.map)";
				}
			} else {
				throw "UMap::validate(): Improperly configured library (missing this.cfg)";
			}
		} catch(e) {
			handleException('UMap::validate(): Invalid configuration', e, true);
		}
	},


	init : function() {
		this.map = new OpenLayers.Map(this.cfg.map.div, this.cfg.map.options);
		this.map.umap = this;

		// GIS layers
		this.backgrounds = this.loadOverlays(this.cfg.map.backgrounds);
		this.map.addLayers(this.backgrounds);
		this.overlays = this.loadOverlays(this.cfg.map.overlays);
		this.map.addLayers(this.overlays);
		if(this.overlays.length > 1 || this.backgrounds.length > 1) {
			this.map.addControl( new OpenLayers.Control.LayerSwitcher());
		}
		if(this.cfg.debug) {
			this.map.addControl(new OpenLayers.Control.MousePosition());
		}


		var proj4326 = new OpenLayers.Projection("EPSG:4326");
		var point = new OpenLayers.LonLat(this.cfg.map.center.lon, this.cfg.map.center.lat);
		var c = point.transform(proj4326, this.map.getProjectionObject());

		this.map.setCenter(c, this.cfg.map.center.zoom);
		this.afterInit(this);
	},

	afterInit : function(umap_ob) {
		// Override using dojo.connect
	},


	loadOverlays : function(arr_overlays) {
		var ret = [];
		try {
			for(var i = 0; i < arr_overlays.length; i++) {
				if(this.validateLayer(arr_overlays[i])) {
					layer = this.createLayer(arr_overlays[i]);
					ret.push(layer);
				}
			}

		} catch(e) {
			console.log(arr_overlays)
			handleException('UMap::loadOverlays(): Error parsing overlays', e, true);
		}
		return ret;
	},



	validateLayer : function(cfg) {
		if(typeof(cfg.type) == 'undefined') {
			throw "UMap::validateLayer(" + cfg + "): Unspecified layer type";
		}
		if(typeof(cfg.name) == 'undefined') {
			throw "UMap::validateLayer(" + cfg + "): Unspecified layer name";
		}
		if(typeof(cfg.cfg) == 'undefined') {
			throw "UMap::validateLayer(" + cfg + "): Unspecified layer configuration";
		}
		return true;
	},


	/**
	 *
	 */
	createLayer : function(cfg) {
		var name = cfg.name;
		var type = cfg.type;
		var layout = {};
		var layer_cfg = cfg.cfg;
		if(typeof(cfg.layout) != 'undefined') {
			layout = cfg.layout;
		}
		if(typeof(cfg.layout.isBaseLayer) == 'undefined') {
			cfg.layout.isBaseLayer = false;
		}

		if(type === 'google') {
			layer_cfg.type = G_NORMAL_MAP;
			return new OpenLayers.Layer.Google(name, layer_cfg, layout);
		}
		else if(type === 'google_hyb') {
			layer_cfg.type = G_HYBRID_MAP;
			return new OpenLayers.Layer.Google(name, layer_cfg, layout);
		}
		else if(type === 'google_sat') {
			layer_cfg.type = G_SATELLITE_MAP;
			return new OpenLayers.Layer.Google(name, layer_cfg, layout);
		}
		else if(type === 'mapserver') {
			return new OpenLayers.Layer.MapServer(name, this.cfg.mapserver.url, layer_cfg, layout);
		}
		else {
			umap_warn('Unimplemented layer type: ' + type);
		}
		return null;
	},

	geocode : function(address) {
		var self = this;
		new GClientGeocoder().getLatLng(address, function(latlng) {
			self.onGeocodeResult(latlng, self);
		});
	},

	onGeocodeResult : function(latlng, umap) {}
});
