dojo.provide('umap.ClickHandler');

umap.ClickHandler = OpenLayers.Class(OpenLayers.Control, {
	defaultHandlerOptions: {
		'single': true,
		'double': false,
		'pixelTolerance': 0,
		'stopSingle': false,
		'stopDouble': false
	},


	initialize: function(options) {
		this.handlerOptions = OpenLayers.Util.extend({}, this.defaultHandlerOptions);
		OpenLayers.Control.prototype.initialize.apply(this, arguments);
		this.handler = new OpenLayers.Handler.Click(this, {'click': this.trigger}, this.handlerOptions);
	},


	busyCursor: function(map, setBusy) {
		if(setBusy) {
			OpenLayers.Element.addClass(map.viewPortDiv, 'olCursorWait');
		} else {
			OpenLayers.Element.removeClass(map.viewPortDiv, 'olCursorWait');
		}
	},

	ut_query_layer_url: function(layer, map, xy) {
		return layer.getFullRequestString({
			mode: null,
			map_imagetype: null,
			REQUEST: 'getfeatureinfo',
			EXCEPTIONS: 'application/vnd.ogc.se_xml',
			bbox: map.getExtent().toBBOX(),
			VERSION: '1.1.1',
			SRS: 'EPSG:4326',
			X: xy.x,
			Y: xy.y,
			INFO_FORMAT: 'gml',
			QUERY_LAYERS: layer.params.layers,
			FEATURE_COUNT: 5,
			WIDTH: map.size.w,
			HEIGHT: map.size.h
		}, UMAP_SETTINGS.mapserver.url);
	},

	ut_gis_basic_url: function(query_layers, map, xy) {
		ret = null;
		if(query_layers.length > 0) {
			var gis_layers_names = this.ut_gis_layers_names(query_layers);
			var tmply = query_layers[0];
			var ret = tmply.getFullRequestString({
				mode: null,
				map_imagetype: null,
				REQUEST: 'getfeatureinfo',
				EXCEPTIONS: 'application/vnd.ogc.se_xml',
				bbox: map.getExtent().toBBOX(),
				VERSION: '1.1.1',
				SRS: 'EPSG:4326',
				X: xy.x,
				Y: xy.y,
				INFO_FORMAT: 'gml',
				QUERY_LAYERS: gis_layers_names,
				FEATURE_COUNT: 5,
				WIDTH: map.size.w,
				HEIGHT: map.size.h
			}, UMAP_SETTINGS.mapserver.url);
		}
		return ret;
	},

	ut_findGISLayers: function (layers) {
		ret = [];
		for(var i = 0; i < layers.length; i++) {
			var ly = layers[i];
			if (ly.CLASS_NAME == 'OpenLayers.Layer.MapServer' && !ly.isBaseLayer && ly.visibility) {
				ret.push(ly);
			}
		}
		return ret;
	},

	ut_gis_layers_names: function (layers) {
		ret = '';
		for(var i = 0; i < layers.length; i++) {
			ret += layers[i].params.layers;
			if(i < layers.length - 1) {
				ret += ',';
			}
		}
		return ret;
	}
});
