/**
 * External parameters
 * UMAP_SETTINGS - Library configuration parameters (dictionary). See below
 */

/*  *********** Global variables here *********  */
UMAP_URL = UMAP_SETTINGS.base_url + "/media/javascript/umap";
var g_umap = null; // Initialized by bootstrap()
/*  *******************************************  */

dojo.registerModulePath("umap", UMAP_URL);
dojo.require("umap.UMap");
dojo.require('umap.Utilities');


function bootstrap() {
	try {
		g_umap = new umap.UMap(UMAP_SETTINGS);
		if(typeof(beforeUMapInit) != 'undefined') {
			beforeUMapInit(g_umap);
		}
		g_umap.init();
	} catch(e) {
		handleException('UMap::bootstrap(): An error occurred during component initialization', e, false);
	}
}
dojo.addOnLoad(bootstrap);


/**
 * umap settings dictionary documentation
 * cfg.base_url - Base URL to the UMap zope object on the server (to load library from)
 * cfg.debug - If true set library in debug mode (shows coordinates in left-bottom corner)
 * cfg.server_url - Absolute URL to the root of the website (http://my.portal.com/test)
 * cfg.map.div
 * 		ID of the HTML DIV that will act as the map viewport
 * cfg.map.center - Dictionary of 3 elements with initial map position. Keys: lat - Latitude, lon - Longitude, zoom - Zoom
 * cfg.map.backgrounds
 * 		Array of different backgrounds available in the framework and 
 * 		switchable. Make sure appropriate libraries are loaded in HTML page.
 * 		MUST have at least one element. Possible values are:
 * 			* google - Google Maps normal background
 * 			* google_hyb - Google Maps hybrid background
 * 			* google_sat - Google Maps satellite background
 * 			* yahoo - Yahoo Maps normal background
 * 			* yahoo_hyb - Yahoo Maps hybrid background
 * 			* yahoo_sat - Yahoo Maps satellite background
 * 			* ve - Virtual Earth normal
 * 			First element is always the one shown initially (background) and layers
 * cfg.map.overlays
 * 		Overlays are stacked on top of each other, first being the downmost with 
 * 		subsequent on top. Usually these are WMS gis layers 
 * 
 */