dojo.require('dojo.string');


function beforeUMapInit(umap) {
	//dojo.byId('coordinates_container').style.display = 'none';
	dojo.connect(umap, 'afterInit', null, 'afterUMapInit');

	dojo.connect(dojo.byId('geocode'), 'onclick', null, function() { doGeocode(umap); });
	dojo.connect(umap, 'onGeocodeResult', null, onGeocodeResult);
}


function doGeocode(umap) {
	var search = '';

	var address = dojo.string.trim(dojo.byId('adoradress').value);
	var zip = dojo.string.trim(dojo.byId('adorzipcode').value);
	var city = dojo.string.trim(dojo.byId('adorcity').value);
	var country = '';
	if(dojo.byId('id_country_other').checked) {
		country = dojo.string.trim(dojo.byId('adorcountry').value);
	}
	search += address + ' ' + zip + ' ' + city + ' ' + country;
	search = dojo.string.trim(search + country + ' ');
	umap.geocode(search);
}


function onGeocodeResult(latlng, umap) {
	if(latlng != null) {
		var map = umap.map;
		umap_clearFeatures(map);
		console.log(latlng);
		var vector = umap_getFirstVectorLayer(umap.map);
		var point = makePoint(umap.map, latlng.lng(), latlng.lat());
		vector.addFeatures([point]);
		map.setCenter(new OpenLayers.LonLat(point.geometry.x, point.geometry.y), 14);
		setCoord(latlng.lat(), latlng.lng());
	}
}


function afterUMapInit(umap) {
	var map = umap.map;

	var myStyles = new OpenLayers.StyleMap({
			"default": new OpenLayers.Style({
			pointRadius: "5", fillColor: "#ff2222", strokeColor: "#2222FF", strokeWidth: 2,
			graphicZIndex: 1
		})
	});
	var vector = new OpenLayers.Layer.Vector("Vector layer", {isBaseLayer: false, isVector: true, displayInLayerSwitcher : false, styleMap: myStyles});
	// Show toolbar with add point button
	var addPointBtn = new OpenLayers.Control.DrawFeature(vector, OpenLayers.Handler.Point, {'displayClass': 'olControlDrawFeaturePoint'});

	var panelControls = [new OpenLayers.Control.Navigation(),addPointBtn];
	var toolbar = new OpenLayers.Control.Panel({displayClass: 'olControlEditingToolbar', defaultControl: panelControls[0]});
	toolbar.addControls(panelControls);
	var dragFeature = new OpenLayers.Control.DragFeature(vector);
	dragFeature.onComplete = function(evt) {
		if(evt) {
			var c = evt.geometry;
			setCoordinates(c, map);
		}
	}

	vector.events.on({"featureadded": function(evt) {
		var feature = evt.feature;
		var point = feature.geometry;
		setCoordinates(point, map);
		toolbar.activateControl(panelControls[0]);
		dragFeature.activate();
	}});

	addPointBtn.events.on({"activate" : function(evt)
		{
			if(vector.features.length > 0) {
				vector.removeFeatures(vector.features);
			}
		}
	});

	map.addLayers([vector]);
	map.addControl(toolbar);
	map.addControl(dragFeature);

	// Add point if was previously on request
	if(valid_coord) {
		var point = makePoint(map, initial_x, initial_y);
		vector.addFeatures([point]);
	}

	map.events.register("zoomend", map, function() {
		var ctrl = dojo.byId('id_zoom');
		if(ctrl) {
			ctrl.value = map.getZoom();
		}
	});
}


function setCoordinates(c, map, force) {
	var point = new OpenLayers.LonLat(c.x, c.y);
	var proj4326 = new OpenLayers.Projection("EPSG:4326");
	var coord = point.transform(map.getProjectionObject(), proj4326);
	setCoord(coord.lat, coord.lon)
}


function setCoord(lat, lon) {
	dojo.byId('id_adorhqx').value = lon;
	dojo.byId('id_adorhqy').value = lat;
}


function makePoint(map, clon, clat) {
	var point = new OpenLayers.Geometry.Point(clon, clat);
	var proj4326 = new OpenLayers.Projection("EPSG:4326");
	point = point.transform(proj4326, map.getProjectionObject());
	return new OpenLayers.Feature.Vector(point);
}
