/**
 * This file is used both by add_sanitation and add_waterpoint pages.
 */
function onChangeLocality(ctrl) {
	if(ctrl.selectedIndex != 0) {
		dojo.byId('id_change_locality').style.display = 'block';
	}
}


function beforeUMapInit(umap) {
	dojo.connect(umap, 'afterInit', null, 'afterUMapInit');
}

function afterUMapInit(umap) {
	var map = umap.map;

	var myStyles = new OpenLayers.StyleMap({
			"default": new OpenLayers.Style({
			pointRadius: "5", fillColor: "#ff2222", strokeColor: "#2222FF", strokeWidth: 2,
			graphicZIndex: 1
		})
	});
	var vector = new OpenLayers.Layer.Vector("Vector layer", {isBaseLayer: false, isVector: true, displayInLayerSwitcher : false, styleMap: myStyles});
	// Show toolbar with add point button
	var addPointBtn = new OpenLayers.Control.DrawFeature(vector, OpenLayers.Handler.Point, {'displayClass': 'olControlDrawFeaturePoint'});

	var panelControls = [new OpenLayers.Control.Navigation(),addPointBtn];
	var toolbar = new OpenLayers.Control.Panel({displayClass: 'olControlEditingToolbar', defaultControl: panelControls[0]});
	toolbar.addControls(panelControls);
	var dragFeature = new OpenLayers.Control.DragFeature(vector);
	dragFeature.onComplete = function(evt) {
		if(evt) {
			var c = evt.geometry;
			setCoordinates(c, map);
		}
	}

	vector.events.on({"featureadded": function(evt) {
		var feature = evt.feature;
		var point = feature.geometry;
		setCoordinates(point, map);
		toolbar.activateControl(panelControls[0]);
		dragFeature.activate();
	}});

	addPointBtn.events.on({"activate" : function(evt) 
		{ 
			if(vector.features.length > 0) {
				vector.removeFeatures(vector.features);
			}
		}
	});

	map.addLayers([vector]);
	map.addControl(toolbar);
	map.addControl(dragFeature);

	if(centerOnReq) {
		// Add point if was previously on request
		var point = makePoint(map, upisx, upisy);
		vector.addFeatures([point]);
	}
	
	map.events.register("zoomend", map, function() {
		var ctrl = dojo.byId('id_zoom');
		if(ctrl) {
			ctrl.value = map.getZoom();
		}
	});
}

function setCoordinates(c, map) {
	var point = new OpenLayers.LonLat(c.x, c.y);
	var proj4326 = new OpenLayers.Projection("EPSG:4326");
	var coord = point.transform(map.getProjectionObject(), proj4326);
	dojo.byId('id_upisx').value = coord.lon;
	dojo.byId('id_upisy').value = coord.lat;
}

function makePoint(map, clon, clat) {
	var point = new OpenLayers.Geometry.Point(clon, clat);
	var proj4326 = new OpenLayers.Projection("EPSG:4326");
	point = point.transform(proj4326, map.getProjectionObject());
	return new OpenLayers.Feature.Vector(point);
}
