# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
#Python imports
from Products.UMap.Customizations import Customizations

#Zope imports
from OFS.Folder import Folder
from AccessControl.SecurityInfo import ClassSecurityInfo
from App.class_init import InitializeClass
import zLOG

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from naaya.core.StaticServe import StaticServeFromZip, StaticServeFromFolder


class UMap(Folder):
    security = ClassSecurityInfo()


    def __init__(self, id=None, *args, **kwargs):
        """
        Initialization
        """
        super(UMap, self).__init__(id, *args, **kwargs)
        zLOG.LOG(__name__, zLOG.INFO, '    * UMap::__init__(): UMap successfully installed')
        self.custom = Customizations('custom')


    def get_custom_gis_filepath(self):
        """ Retrieve the path to GIS mapfile """
        return '%s/custom.map' % self.gis_path


    security.declarePublic('get_custom_overlays')
    def get_custom_overlays(self):
        """ Retrieve the active backgrounds. First is always the default """
        return self.get_setting('locality.umap.overlays')


    _index_html = NaayaPageTemplateFile('zpt/index', globals(), 'ws_umap_test')
    def index_html(self, REQUEST):
        """ Module index page """
        return self._index_html(REQUEST, debug=self.debug)


    _umap_slot = NaayaPageTemplateFile('zpt/umap_slot', globals(), 'ws_umap_slot')
    def umap_slot(self, center_lat='', center_lng='', zoom='', backgrounds='', 
                   overlays=[], mapoptions={'numZoomLevels': 23}, domain='', onClick='', REQUEST=None):
        """ Injects all the necessary code to create the map """
        if not center_lat:
            center_lat = self.default_latitude
        if not center_lng:
            center_lng = self.default_longitude
        if not zoom:
            zoom = self.default_zoom

        return self._umap_slot(REQUEST, debug=str(self.debug).lower(), 
                        center_lat=center_lat, center_lng=center_lng, zoom=zoom,
                        backgrounds=backgrounds, overlays=overlays,
                        mapoptions=mapoptions, domain=domain, onClick=onClick)


    _legend = NaayaPageTemplateFile('zpt/legend', globals(), 'ws_umap_legend')
    def legend(self, show_wp=False, show_sf=False, show_pws=False, show_reservoir=False, 
                    show_locality=False, show_uws=False, show_station=False, REQUEST=None):
        return self._legend(REQUEST, show_wp=show_wp, show_sf=show_sf, 
                            show_pws=show_pws, show_reservoir=show_reservoir, 
                            show_locality=show_locality, show_uws=show_uws, 
                            show_station=show_station)


    dojo = StaticServeFromZip('dojo-release-1.4.1/dojo', 'www/javascript/dojo-release-1.4.1.zip', globals())
    dijit = StaticServeFromZip('dojo-release-1.4.1/dijit', 'www/javascript/dojo-release-1.4.1.zip', globals())
    dojox = StaticServeFromZip('dojo-release-1.4.1/dojox', 'www/javascript/dojo-release-1.4.1.zip', globals())

    media = StaticServeFromFolder('www', globals(), cache=False)


InitializeClass(UMap)