'''
Created on Mar 8, 2010

@author: cristiroma
'''
from ws.common.tests import WatsanTestCase
from unittest import TestSuite, makeSuite
from ws.common.xml.Serializer import Serializer, XMLSerializer



class SerializerTest(WatsanTestCase):

    def test_serialize(self):
        ser = Serializer()
        self.assertRaises(NotImplementedError, ser.serialize, None)

    def test_serialize_item(self):
        ser = Serializer()
        self.assertRaises(NotImplementedError, ser.serialize_item, None)


class Probe(object):
    
    def __init__(self):
        self.one = 1
        self.two = 2
        self.astring = '"'


class XmlSerializerTest(WatsanTestCase):


    def test_serialize_item(self):
        xmlser = XMLSerializer(None)
        node = xmlser.serialize_item(Probe())
        self.assertNotEqual(node, None)
        self.assertTrue(len(node.attributes.keys()) == 3)
        self.assertTrue('one' in node.attributes.keys())
        self.assertTrue('two' in node.attributes.keys())
        self.assertTrue('astring' in node.attributes.keys())
        self.assertEqual('1', node.attributes['one'].value)
        self.assertEqual('2', node.attributes['two'].value)
        #self.assertEqual('"', node.attributes['astring'].value)



class JsonSerializerTest(WatsanTestCase):


    def test_serialize_item(self):
        pass



def test_suite():
    """
    Test suite for the watsan.common package
    """
    suite = TestSuite()
    suite.addTest(makeSuite(SerializerTest))
    suite.addTest(makeSuite(XmlSerializerTest))
    return suite

