'''
Created on Mar 8, 2010

@author: cristiroma
'''
from types import ListType, StringType, UnicodeType
import sys, traceback
from xml.dom import minidom
from urllib import quote


class Serializer(object):
    """
    Base class for data serializers into web standards (XML, JSON, CSV etc.)
    """
    XML_PROLOG = '<?xml version="1.0" encoding="UTF-8"?>'


    def serialize(self, data):
        """
        Serialize given data
        @param data: [list] Element(s) serialize
        """
        raise NotImplementedError()


    def serialize_item(self, item):
        """
        Encode single item individually
        @param item: Item to be encoded
        """
        raise NotImplementedError()



class XMLSerializer(Serializer):


    def __init__(self, fields=None):
        self.doc = minidom.Document()
        self.root = self.doc.createElement('response')
        self.fields = fields


    def serialize(self, ob_array):
        array = ob_array
        if not isinstance(ob_array, ListType):
            array = [ob_array]
        ret = ''
        try:
            for ob in array:
                self.root.appendChild(self.serialize_item(ob))
            ret = '\n'.join([self.XML_PROLOG, self.root.toxml()])
        except:
            klass, exc, trbk = sys.exc_info()
            ret = self.get_error(klass, exc, trbk)
        return ret


    def serialize_item(self, ob):
        item = self.doc.createElement('item')
        for key in ob.__dict__.keys():
            add = (not self.fields) or (self.fields and (key in self.fields))
            if add:
                val = ob.__dict__[key]
                if not isinstance(val, StringType) or not isinstance(val, UnicodeType):
                    val = str(val)
                item.setAttribute(key, quote(val))
        return item


    def get_error(self, excName, excArgs, excTb):
        s = '<error><name>%s</name><args>%s</args><trace>%s</trace></error>' % (str(excName), str(excArgs), str(excTb))
        return '\n'.join([self.XML_PROLOG, s])


    def decodeException(self, klass, exc, trbk, depth=5):
        """
        Decode an exception stack.
        @param maxTBlevel: [integer]depth level
        """
        excName = klass.__name__
        try:
            excArgs = exc.__dict__['args']
        except KeyError:
            excArgs = '<no args>'
        excTb = traceback.format_tb(trbk, depth)
        return (excName, excArgs, excTb)



class AjaxJSONSerializer(Serializer):


        def serialize(self, ob_array):
            ret = []
            array = ob_array
            if not isinstance(ob_array, ListType):
                array = [ob_array]
            try:
                for ob in array:
                    ret.append(ob.as_json())
            except Exception, ex:
                klass, exc, trbk = sys.exc_info()
                print klass, exc, trbk
                raise ex
            return ret
