'''
Created on Mar 24, 2010

@author: cristiroma
'''
from ws.common.sql.mappings.Country import Country
import formencode
from ws.common.sql.mappings import Lexicon as lex_models
from ws.common.sql.mappings.Upis import Upis

def validate_waterpoint_approval(session, form):
    errors = []

    if not (form.has_key('upisx') and form['upisx']):
        errors.append('upisx')
    if not (form.has_key('upisy') and form['upisy']):
        errors.append('upisy')
    return errors

def validate_sanitation_facility_approval(session, form):
    return validate_waterpoint_approval(session, form)

##############################################################################
def validate_lexicon(value, klass, session):
    try:
        session.query(klass).filter_by(code=value).one()
    except:
        raise formencode.Invalid("Please select a value from the list", value, session)


class NotEmptyValidator(formencode.FancyValidator):
    not_empty = True


class CGE004Validator(NotEmptyValidator):
    """ """
    def validate_other(self, value, state):
        validate_lexicon(value, lex_models.LexCGE004, state)


class CGE007Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCGE007, state)


class CGE008Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCGE008, state)


class CPV004Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCPV004, state)


class CIN006Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCIN006, state)


class CPP004Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCPP004, state)


class CHP005Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCHP005, state)


class CWM005Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCWM005, state)


class CWM006Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexCWM006, state)


class UpisloctypeValidator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexUpisloctype, state)


class WP009Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexWP009, state)


class WP051Validator(NotEmptyValidator):

    def validate_python(self, value, state):
        validate_lexicon(value, lex_models.LexWP051, state)


class NewPortalCountryValidator(NotEmptyValidator):

    def validate_python(self, value, state):
        session = state
        try:
            session.query(Country).filter(Country.adcncodex == value).one()
            return None
        except:
            pass
        raise formencode.Invalid("Selected country cannot be used to create its country portal", value, session)

