# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web

#Python imports
from unittest import TestSuite, makeSuite
from BeautifulSoup import BeautifulSoup

#Watsan imports
from ws.common.tests import WatsanTestCase
from ws.common.utilities.rating.rating import Rating

class StarsRatingTests(WatsanTestCase):
    """docstring for StarsRatingTests"""
    def afterSetUp(self):
        self.stars_url = self.portal.absolute_url() + '/rating/stars?rating=%s&max_rating=%s&error_to_stderr=%s'
        self.stars_edit_url = self.portal.absolute_url() + '/rating/stars_edit?input_name=%s&rating=%s&max_rating=%s&error_to_stderr=%s'

    def beforeTearDown(self):
        pass

    def test_portal_has_rating(self):
        self.assertTrue(hasattr(self.portal, 'rating'))
        self.assertTrue(isinstance(self.portal.rating, Rating))

    def test_view_good_rating(self):
        star_num = 2
        max_star_num = 5

        self.browser.open(self.stars_url % (star_num, max_star_num, True))
        soup = BeautifulSoup(self.browser.contents)

        stars = soup.findAll('img', attrs={'alt': '1'})
        non_stars = soup.findAll('img', attrs={'alt': '0'})

        self.assertTrue(len(stars) == star_num + 1)
        self.assertTrue(len(non_stars) == max_star_num - star_num - 1)

    def test_view_bad_rating(self):
        star_num = 'a'
        max_star_num = 5

        self.browser.open(self.stars_url % (star_num, max_star_num, False))
        self.assertEqual(self.browser.contents, 'RATING ERROR')

    def test_edit_good_rating(self):
        star_num = 3
        max_star_num = 5

        self.browser.open(self.stars_edit_url % ('kk', star_num, max_star_num, True))
        soup = BeautifulSoup(self.browser.contents)
        for i in range(max_star_num):
            img = soup.find('img', attrs={'alt': str(i)})
            self.assertTrue(img is not None)
            src = self.portal.absolute_url() + '/rating/media/'
            if i > star_num:
                src += 'small_gray_star.gif'
            else:
                src += 'small_yellow.star.gif'
            self.assertTrue(img['src'])

    def test_edit_bad_rating(self):
        star_num = 'a'
        max_star_num = 5

        self.browser.open(self.stars_edit_url % ('kk', star_num, max_star_num, False))
        self.assertEqual(self.browser.contents, 'RATING ERROR')


def test_suite():
    """
    Test suite for the watsan.common package
    """
    suite = TestSuite()
    suite.addTest(makeSuite(StarsRatingTests))
    return suite

