# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web

import zLOG

#Zope imports
from OFS.SimpleItem import SimpleItem
from AccessControl.SecurityInfo import ClassSecurityInfo
from AccessControl.Permissions import view
from Products.PageTemplates.PageTemplateFile import PageTemplateFile

#Naaya imports
from naaya.core.StaticServe import StaticServeFromFolder

class Rating(SimpleItem):
    """
    This is a tool class.
    It defines methods for rating interface.

    On error: this will not raise an exception,
    it will just return 'RATING ERROR' on the page
    """

    security = ClassSecurityInfo()

    security.declareProtected(view, 'stars')
    _stars = PageTemplateFile('zpt/stars', globals())
    def stars(self, rating, max_rating=5, small=False):
        """
        Returns HTML view of stars rating
        !!! error_to_stderr should only be used for bad values tests
        """
        try:
            rating = int(rating)
            max_rating = int(max_rating)
            return self._stars(rating=rating, max_rating=max_rating, small=small)
        except Exception, e:
            #zLOG.LOG(__name__, zLOG.INFO, 'WSPortal::rating: Rating error')
            return None

    security.declareProtected(view, 'stars_edit')
    _stars_edit = PageTemplateFile('zpt/stars_edit', globals())
    def stars_edit(self, input_name, rating, max_rating=5):
        """ """
        try:
            rating = int(rating)
            max_rating = int(max_rating)
            return self._stars_edit(id=input_name, rating=rating, max_rating=max_rating)
        except Exception, e:
            #zLOG.LOG(__name__, zLOG.INFO, 'WSPortal::rating: Rating error')
            return None

    security.declareProtected(view, 'checkboxes')
    _checkboxes = PageTemplateFile('zpt/checkboxes', globals())
    def checkboxes(self, rating, max_rating=5):
        """ """
        try:
            rating = int(rating)
            max_rating = int(max_rating)
            print '-'*60, rating, max_rating

            return self._checkboxes(rating=rating, max_rating=max_rating)
        except Exception, e:
            #zLOG.LOG(__name__, zLOG.INFO, 'WSPortal::rating: Rating error')
            return None

    media = StaticServeFromFolder('media', globals(), cache=True)