from formencode import Schema, validators, Invalid
try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO

try:
    from PIL import Image
except ImportError:
    import Image


class PhotoUploadValidator(validators.FancyValidator):
    def _to_python(self, value, state):
        if not value:
            raise Invalid('Image field cannot be empty', value, state)

        if hasattr(value, 'read'):
            file = StringIO(value.read())
        else:
            file = StringIO(value['content'])

        try:
            trial_image = Image.open(file)
            trial_image.verify()
        except Exception: #Python Imaging Library doesn't recognize it as an image
            raise Invalid('Invalid image. Wrong file type detected for file %s' % value.filename, value, state)

        if hasattr(value, 'seek') and callable(value.seek):
            value.seek(0)
        return value

class PhotoUploadForm(Schema):
    filter_extra_fields = True
    allow_extra_fields = True
    title = validators.String()
    file = PhotoUploadValidator()